/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.rmi.impl.server;

import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.jcr.Item;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.lock.Lock;
import javax.jcr.nodetype.ItemDefinition;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.ObservationManager;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteAdapterFactory;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteEventCollection;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteItem;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteIterator;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteLock;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteNamespaceRegistry;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteNode;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteObservationManager;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteProperty;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteQuery;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteQueryManager;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteQueryResult;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteRepository;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteRow;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteSession;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteVersion;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteVersionHistory;
import org.exoplatform.services.jcr.rmi.api.remote.RemoteWorkspace;
import org.exoplatform.services.jcr.rmi.api.remote.iterator.ArrayIterator;
import org.exoplatform.services.jcr.rmi.api.remote.iterator.BufferIterator;
import org.exoplatform.services.jcr.rmi.api.remote.nodetype.RemoteItemDefinition;
import org.exoplatform.services.jcr.rmi.api.remote.nodetype.RemoteNodeDefinition;
import org.exoplatform.services.jcr.rmi.api.remote.nodetype.RemoteNodeType;
import org.exoplatform.services.jcr.rmi.api.remote.nodetype.RemoteNodeTypeManager;
import org.exoplatform.services.jcr.rmi.api.remote.nodetype.RemotePropertyDefinition;
import org.exoplatform.services.jcr.rmi.impl.server.ServerEventCollection;
import org.exoplatform.services.jcr.rmi.impl.server.ServerItem;
import org.exoplatform.services.jcr.rmi.impl.server.ServerItemDefinition;
import org.exoplatform.services.jcr.rmi.impl.server.ServerLock;
import org.exoplatform.services.jcr.rmi.impl.server.ServerNamespaceRegistry;
import org.exoplatform.services.jcr.rmi.impl.server.ServerNode;
import org.exoplatform.services.jcr.rmi.impl.server.ServerNodeDefinition;
import org.exoplatform.services.jcr.rmi.impl.server.ServerNodeType;
import org.exoplatform.services.jcr.rmi.impl.server.ServerNodeTypeManager;
import org.exoplatform.services.jcr.rmi.impl.server.ServerObservationManager;
import org.exoplatform.services.jcr.rmi.impl.server.ServerProperty;
import org.exoplatform.services.jcr.rmi.impl.server.ServerPropertyDefinition;
import org.exoplatform.services.jcr.rmi.impl.server.ServerQuery;
import org.exoplatform.services.jcr.rmi.impl.server.ServerQueryManager;
import org.exoplatform.services.jcr.rmi.impl.server.ServerQueryResult;
import org.exoplatform.services.jcr.rmi.impl.server.ServerRepository;
import org.exoplatform.services.jcr.rmi.impl.server.ServerRow;
import org.exoplatform.services.jcr.rmi.impl.server.ServerSession;
import org.exoplatform.services.jcr.rmi.impl.server.ServerVersion;
import org.exoplatform.services.jcr.rmi.impl.server.ServerVersionHistory;
import org.exoplatform.services.jcr.rmi.impl.server.ServerWorkspace;
import org.exoplatform.services.jcr.rmi.impl.server.iterator.ServerNodeIterator;
import org.exoplatform.services.jcr.rmi.impl.server.iterator.ServerNodeTypeIterator;
import org.exoplatform.services.jcr.rmi.impl.server.iterator.ServerPropertyIterator;
import org.exoplatform.services.jcr.rmi.impl.server.iterator.ServerRowIterator;
import org.exoplatform.services.jcr.rmi.impl.server.iterator.ServerVersionIterator;

public class RemoteAdapterFactoryImpl
implements RemoteAdapterFactory {
    private static final int DEFAULT_BUFFER_SIZE = 100;
    private int bufferSize = 100;

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public RemoteRepository getRemoteRepository(Repository repository) throws RemoteException {
        return new ServerRepository(repository, this);
    }

    public RemoteSession getRemoteSession(Session session) throws RemoteException {
        return new ServerSession(session, this);
    }

    public RemoteWorkspace getRemoteWorkspace(Workspace workspace) throws RemoteException {
        return new ServerWorkspace(workspace, this);
    }

    public RemoteObservationManager getRemoteObservationManager(ObservationManager observationManager) throws RemoteException {
        return new ServerObservationManager(observationManager, this);
    }

    public RemoteNamespaceRegistry getRemoteNamespaceRegistry(NamespaceRegistry registry) throws RemoteException {
        return new ServerNamespaceRegistry(registry, this);
    }

    public RemoteNodeTypeManager getRemoteNodeTypeManager(NodeTypeManager manager) throws RemoteException {
        return new ServerNodeTypeManager(manager, this);
    }

    public RemoteItem getRemoteItem(Item item) throws RemoteException {
        return new ServerItem(item, this);
    }

    public RemoteProperty getRemoteProperty(Property property) throws RemoteException {
        return new ServerProperty(property, (RemoteAdapterFactory)this);
    }

    public RemoteNode getRemoteNode(Node node) throws RemoteException {
        return new ServerNode(node, (RemoteAdapterFactory)this);
    }

    public RemoteVersion getRemoteVersion(Version version) throws RemoteException {
        return new ServerVersion(version, (RemoteAdapterFactory)this);
    }

    public RemoteVersionHistory getRemoteVersionHistory(VersionHistory versionHistory) throws RemoteException {
        return new ServerVersionHistory(versionHistory, (RemoteAdapterFactory)this);
    }

    public RemoteNodeType getRemoteNodeType(NodeType type) throws RemoteException {
        return new ServerNodeType(type, this);
    }

    public RemoteItemDefinition getRemoteItemDefinition(ItemDefinition def) throws RemoteException {
        return new ServerItemDefinition(def, this);
    }

    public RemoteNodeDefinition getRemoteNodeDefinition(NodeDefinition def) throws RemoteException {
        return new ServerNodeDefinition(def, (RemoteAdapterFactory)this);
    }

    public RemotePropertyDefinition getRemotePropertyDefinition(PropertyDefinition def) throws RemoteException {
        return new ServerPropertyDefinition(def, (RemoteAdapterFactory)this);
    }

    public RemoteLock getRemoteLock(Lock lock) throws RemoteException {
        return new ServerLock(lock, this);
    }

    public RemoteQueryManager getRemoteQueryManager(QueryManager manager, Session session) throws RemoteException {
        return new ServerQueryManager(manager, this, session);
    }

    public RemoteQuery getRemoteQuery(Query query) throws RemoteException {
        return new ServerQuery(query, this);
    }

    public RemoteQueryResult getRemoteQueryResult(QueryResult result) throws RemoteException {
        return new ServerQueryResult(result, this);
    }

    public RemoteRow getRemoteRow(Row row) throws RemoteException {
        return new ServerRow(row, this);
    }

    public RemoteEventCollection getRemoteEvent(long listenerId, EventIterator events) throws RemoteException {
        RemoteEventCollection.RemoteEvent[] remoteEvents;
        if (events != null) {
            ArrayList<ServerEventCollection.ServerEvent> eventList = new ArrayList<ServerEventCollection.ServerEvent>();
            while (events.hasNext()) {
                try {
                    Event event = events.nextEvent();
                    eventList.add(new ServerEventCollection.ServerEvent(event.getType(), event.getPath(), event.getUserID()));
                }
                catch (RepositoryException re) {
                    throw new RemoteException(re.getMessage(), re);
                }
            }
            remoteEvents = eventList.toArray(new RemoteEventCollection.RemoteEvent[eventList.size()]);
        } else {
            remoteEvents = new RemoteEventCollection.RemoteEvent[]{};
        }
        return new ServerEventCollection(listenerId, remoteEvents);
    }

    protected RemoteIterator optimizeIterator(RemoteIterator remote) throws RemoteException {
        Object[] elements = remote.nextObjects();
        long size = remote.getSize();
        if (size == -1L || elements != null && size > (long)elements.length) {
            return new BufferIterator(elements, size, remote);
        }
        return new ArrayIterator(elements);
    }

    public RemoteIterator getRemoteNodeIterator(NodeIterator iterator) throws RemoteException {
        return this.optimizeIterator(new ServerNodeIterator(iterator, (RemoteAdapterFactory)this, this.bufferSize));
    }

    public RemoteIterator getRemotePropertyIterator(PropertyIterator iterator) throws RemoteException {
        return this.optimizeIterator(new ServerPropertyIterator(iterator, (RemoteAdapterFactory)this, this.bufferSize));
    }

    public RemoteIterator getRemoteVersionIterator(VersionIterator iterator) throws RemoteException {
        return this.optimizeIterator(new ServerVersionIterator(iterator, (RemoteAdapterFactory)this, this.bufferSize));
    }

    public RemoteIterator getRemoteNodeTypeIterator(NodeTypeIterator iterator) throws RemoteException {
        return this.optimizeIterator(new ServerNodeTypeIterator(iterator, (RemoteAdapterFactory)this, this.bufferSize));
    }

    public RemoteIterator getRemoteRowIterator(RowIterator iterator) throws RemoteException {
        return this.optimizeIterator(new ServerRowIterator(iterator, (RemoteAdapterFactory)this, this.bufferSize));
    }
}

