/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav;

import java.util.Hashtable;

public class WebDavStatus {
    public static final int CONTINUE = 100;
    public static final int SWITCHING_PROTOCOLS = 101;
    public static final int OK = 200;
    public static final int CREATED = 201;
    public static final int ACCEPTED = 202;
    public static final int NON_AUTHORITATIVE_INFORMATION = 203;
    public static final int NO_CONTENT = 204;
    public static final int RESET_CONTENT = 205;
    public static final int PARTIAL_CONTENT = 206;
    public static final int MULTISTATUS = 207;
    public static final int MULTIPLE_CHOICES = 300;
    public static final int MOVED_PERMANENTLY = 301;
    public static final int FOUND = 302;
    public static final int SEE_OTHER = 303;
    public static final int NOT_MODIFIED = 304;
    public static final int USE_PROXY = 305;
    public static final int TEMPORARY_REDIRECT = 307;
    public static final int BAD_REQUEST = 400;
    public static final int UNAUTHORIZED = 401;
    public static final int PAYMENT_REQUIRED = 402;
    public static final int FORBIDDEN = 403;
    public static final int NOT_FOUND = 404;
    public static final int METHOD_NOT_ALLOWED = 405;
    public static final int NOT_ACCEPTABLE = 406;
    public static final int PROXY_AUTHENTICATION_REQUIRED = 407;
    public static final int REQUEST_TIMEOUT = 408;
    public static final int CONFLICT = 409;
    public static final int GONE = 410;
    public static final int LENGTH_REQUIRED = 411;
    public static final int PRECONDITION_FAILED = 412;
    public static final int REQUEST_ENTITY_TOO_LARGE = 413;
    public static final int REQUEST_URI_TOO_LONG = 414;
    public static final int UNSUPPORTED_MEDIA_TYPE = 415;
    public static final int REQUESTED_RANGE_NOT_SATISFIABLE = 416;
    public static final int EXPECTATION_FAILED = 417;
    public static final int LOCKED = 423;
    public static final int INTERNAL_SERVER_ERROR = 500;
    public static final int NOT_IMPLEMENTED = 501;
    public static final int BAD_GATEWAY = 502;
    public static final int SERVICE_UNAVAILABLE = 503;
    public static final int GATEWAY_TIMEOUT = 504;
    public static final int HTTP_VERSION_NOT_SUPPORTED = 505;
    private static Hashtable<Integer, String> statusDescriptions = new Hashtable();

    private static void registerDescr(int status, String descr) {
        statusDescriptions.put(new Integer(status), descr);
    }

    public static final String getStatusDescription(int status) {
        String description = "";
        Integer statusKey = new Integer(status);
        if (statusDescriptions.containsKey(statusKey)) {
            description = statusDescriptions.get(statusKey);
        }
        return String.format("%s %d %s", "HTTP/1.1", status, description);
    }

    static {
        WebDavStatus.registerDescr(100, "Continue");
        WebDavStatus.registerDescr(101, "Switching Protocols");
        WebDavStatus.registerDescr(200, "OK");
        WebDavStatus.registerDescr(201, "Created");
        WebDavStatus.registerDescr(202, "Accepted");
        WebDavStatus.registerDescr(203, "Non-Authoritative Information");
        WebDavStatus.registerDescr(204, "No Content");
        WebDavStatus.registerDescr(205, "Reset Content");
        WebDavStatus.registerDescr(206, "Partial Content");
        WebDavStatus.registerDescr(207, "Multi Status");
        WebDavStatus.registerDescr(300, "Multiple Choices");
        WebDavStatus.registerDescr(301, "Moved Permanently");
        WebDavStatus.registerDescr(302, "Found");
        WebDavStatus.registerDescr(303, "See Other");
        WebDavStatus.registerDescr(304, "Not Modified");
        WebDavStatus.registerDescr(305, "Use Proxy");
        WebDavStatus.registerDescr(307, "Temporary Redirect");
        WebDavStatus.registerDescr(400, "Bad Request");
        WebDavStatus.registerDescr(401, "Unauthorized");
        WebDavStatus.registerDescr(402, "Payment Required");
        WebDavStatus.registerDescr(403, "Forbidden");
        WebDavStatus.registerDescr(404, "Not Found");
        WebDavStatus.registerDescr(405, "Method Not Allowed");
        WebDavStatus.registerDescr(406, "Not Acceptable");
        WebDavStatus.registerDescr(407, "Proxy Authentication Required");
        WebDavStatus.registerDescr(408, "Request Timeout");
        WebDavStatus.registerDescr(409, "Conflict");
        WebDavStatus.registerDescr(410, "Gone");
        WebDavStatus.registerDescr(411, "Length Required");
        WebDavStatus.registerDescr(412, "Precondition Failed");
        WebDavStatus.registerDescr(413, "Request Entity Too Large");
        WebDavStatus.registerDescr(414, "Request-URI Too Long");
        WebDavStatus.registerDescr(415, "Unsupported Media Type");
        WebDavStatus.registerDescr(416, "Requested Range Not Satisfiable");
        WebDavStatus.registerDescr(417, "Expectation Failed");
        WebDavStatus.registerDescr(500, "Internal Server Error");
        WebDavStatus.registerDescr(501, "Not Implemented");
        WebDavStatus.registerDescr(502, "Bad Gateway");
        WebDavStatus.registerDescr(503, "Service Unavailable");
        WebDavStatus.registerDescr(504, "Gateway Timeout");
        WebDavStatus.registerDescr(505, "HTTP Version Not Supported");
    }
}

