/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessControlException;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.services.jcr.webdav.Depth;
import org.exoplatform.services.jcr.webdav.command.lock.LockRequestEntity;
import org.exoplatform.services.jcr.webdav.lock.NullResourceLocksHolder;
import org.exoplatform.services.jcr.webdav.resource.GenericResource;
import org.exoplatform.services.jcr.webdav.xml.PropertyWriteUtil;
import org.exoplatform.services.jcr.webdav.xml.WebDavNamespaceContext;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.transformer.SerializableEntity;

public class LockCommand {
    private final NullResourceLocksHolder nullResourceLocks;

    public LockCommand(NullResourceLocksHolder nullResourceLocks) {
        this.nullResourceLocks = nullResourceLocks;
    }

    public Response lock(Session session, String path, HierarchicalProperty body, Depth depth, String timeout) {
        try {
            String lockToken;
            WebDavNamespaceContext nsContext = new WebDavNamespaceContext(session);
            try {
                Node node = (Node)session.getItem(path);
                if (!node.isNodeType("mix:lockable") && node.canAddMixin("mix:lockable")) {
                    node.addMixin("mix:lockable");
                    session.save();
                }
                Lock lock = node.lock(depth.getIntValue() != 1, false);
                lockToken = lock.getLockToken();
            }
            catch (PathNotFoundException pexc) {
                lockToken = this.nullResourceLocks.addLock(session, path);
            }
            LockRequestEntity requestEntity = new LockRequestEntity(body);
            return Response.Builder.ok((Object)this.body(nsContext, requestEntity, depth, lockToken, requestEntity.getOwner(), timeout), (String)"text/xml").header("Lock-Token", "<" + lockToken + ">").build();
        }
        catch (LockException e) {
            return Response.Builder.withStatus((int)423).errorMessage(e.getMessage()).build();
        }
        catch (AccessDeniedException e) {
            if (this.isReadOnly(session, path)) {
                return Response.Builder.withStatus((int)423).errorMessage("This is read only node.").build();
            }
            return Response.Builder.withStatus((int)403).errorMessage(e.getMessage()).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.serverError().errorMessage(e.getMessage()).build();
        }
    }

    private final SerializableEntity body(WebDavNamespaceContext nsContext, LockRequestEntity input, Depth depth, String lockToken, String lockOwner, String timeout) {
        return new LockResultResponseEntity(nsContext, lockToken, lockOwner, timeout);
    }

    private boolean isReadOnly(Session session, String path) {
        try {
            session.checkPermission(path, "read");
        }
        catch (AccessControlException e1) {
            return false;
        }
        catch (RepositoryException e1) {
            return false;
        }
        try {
            session.checkPermission(path, "set_property");
            return false;
        }
        catch (AccessControlException e) {
            return true;
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public class LockResultResponseEntity
    implements SerializableEntity {
        protected WebDavNamespaceContext nsContext;
        protected String lockToken;
        protected String lockOwner;
        protected String timeOut;

        public LockResultResponseEntity(WebDavNamespaceContext nsContext, String lockToken, String lockOwner, String timeOut) {
            this.nsContext = nsContext;
            this.lockToken = lockToken;
            this.lockOwner = lockOwner;
            this.timeOut = timeOut;
        }

        public void writeObject(OutputStream stream) throws IOException {
            try {
                XMLStreamWriter xmlStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(stream, "UTF-8");
                xmlStreamWriter.setNamespaceContext(this.nsContext);
                xmlStreamWriter.setDefaultNamespace("DAV:");
                xmlStreamWriter.writeStartDocument();
                xmlStreamWriter.writeStartElement("D", "prop", "DAV:");
                xmlStreamWriter.writeNamespace("D", "DAV:");
                HierarchicalProperty lockDiscovery = GenericResource.lockDiscovery(this.lockToken, this.lockOwner, this.timeOut);
                PropertyWriteUtil.writeProperty(xmlStreamWriter, lockDiscovery);
                xmlStreamWriter.writeEndElement();
                xmlStreamWriter.writeEndDocument();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IOException(e.getMessage());
            }
        }
    }
}

