/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import org.exoplatform.services.rest.CacheControl;
import org.exoplatform.services.rest.Response;

public class MoveCommand {
    private static CacheControl cacheControl = new CacheControl();
    private final boolean itemExisted;

    public MoveCommand() {
        this.itemExisted = false;
    }

    public MoveCommand(boolean itemExisted) {
        this.itemExisted = itemExisted;
    }

    public Response move(Session session, String srcPath, String destPath) {
        try {
            session.move(srcPath, destPath);
            session.save();
            if (this.itemExisted) {
                return Response.Builder.withStatus((int)204).cacheControl(cacheControl).build();
            }
            return Response.Builder.withStatus((int)201).cacheControl(cacheControl).build();
        }
        catch (LockException exc) {
            return Response.Builder.withStatus((int)423).build();
        }
        catch (PathNotFoundException exc) {
            return Response.Builder.withStatus((int)409).build();
        }
        catch (RepositoryException exc) {
            exc.printStackTrace();
            return Response.Builder.serverError().build();
        }
    }

    public Response move(Session sourceSession, Session destSession, String srcPath, String destPath) {
        try {
            destSession.getWorkspace().copy(sourceSession.getWorkspace().getName(), srcPath, destPath);
            sourceSession.getItem(srcPath).remove();
            sourceSession.save();
            if (this.itemExisted) {
                return Response.Builder.withStatus((int)204).cacheControl(cacheControl).build();
            }
            return Response.Builder.withStatus((int)201).cacheControl(cacheControl).build();
        }
        catch (LockException e) {
            return Response.Builder.withStatus((int)423).errorMessage(e.getMessage()).build();
        }
        catch (PathNotFoundException e) {
            return Response.Builder.withStatus((int)409).errorMessage(e.getMessage()).build();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return Response.Builder.serverError().errorMessage(e.getMessage()).build();
        }
    }

    static {
        cacheControl.setNoCache(true);
    }
}

