/*
 * Copyright (C) 2003-2007 eXo Platform SAS.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see<http://www.gnu.org/licenses/>.
 */

package org.exoplatform.services.jcr.webdav.command;

import javax.jcr.Item;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

import org.exoplatform.services.jcr.webdav.WebDavStatus;
import org.exoplatform.services.rest.Response;

/**
 * Created by The eXo Platform SAS Author : Vitaly Guly <gavrikvetal@gmail.com>
 * 
 * @version $Id: DeleteCommand.java 39871 2009-11-06 15:59:42Z dkatayev $
 */

public class DeleteCommand {

  public Response delete(Session session, String path) {
    try {
      Item item = session.getItem(path);
      item.remove();
      session.save();
      return Response.Builder.withStatus(WebDavStatus.NO_CONTENT).build();

    } catch (PathNotFoundException e) {
      return Response.Builder.notFound().errorMessage(e.getMessage()).build();

    } catch (RepositoryException e) {
      return Response.Builder.forbidden().errorMessage(e.getMessage()).build();
    }
  }

}
