/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.xml.namespace.QName;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.services.jcr.webdav.command.proppatch.PropPatchResponseEntity;
import org.exoplatform.services.jcr.webdav.lock.NullResourceLocksHolder;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.jcr.webdav.xml.WebDavNamespaceContext;
import org.exoplatform.services.rest.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropPatchCommand {
    protected final NullResourceLocksHolder lockHolder;

    public PropPatchCommand(NullResourceLocksHolder lockHolder) {
        this.lockHolder = lockHolder;
    }

    public Response propPatch(Session session, String path, HierarchicalProperty body, List<String> tokens, String baseURI) {
        try {
            this.lockHolder.checkLock(session, path, tokens);
            Node node = (Node)session.getItem(path);
            WebDavNamespaceContext nsContext = new WebDavNamespaceContext(session);
            URI uri = new URI(TextUtil.escape(baseURI + node.getPath(), '%', true));
            List<HierarchicalProperty> setList = Collections.emptyList();
            if (body.getChild(new QName("DAV:", "set")) != null) {
                setList = this.setList(body);
            }
            List<HierarchicalProperty> removeList = Collections.emptyList();
            if (body.getChild(new QName("DAV:", "remove")) != null) {
                removeList = this.removeList(body);
            }
            PropPatchResponseEntity entity = new PropPatchResponseEntity(nsContext, node, uri, setList, removeList);
            return Response.Builder.withStatus((int)207).entity((Object)entity).build();
        }
        catch (PathNotFoundException e) {
            return Response.Builder.notFound().errorMessage(e.getMessage()).build();
        }
        catch (LockException e) {
            return Response.Builder.withStatus((int)423).errorMessage(e.getMessage()).build();
        }
        catch (Exception e) {
            return Response.Builder.serverError().errorMessage(e.getMessage()).build();
        }
    }

    public List<HierarchicalProperty> setList(HierarchicalProperty request) {
        HierarchicalProperty set = request.getChild(new QName("DAV:", "set"));
        HierarchicalProperty prop = set.getChild(new QName("DAV:", "prop"));
        List setList = prop.getChildren();
        return setList;
    }

    public List<HierarchicalProperty> removeList(HierarchicalProperty request) {
        HierarchicalProperty remove = request.getChild(new QName("DAV:", "remove"));
        HierarchicalProperty prop = remove.getChild(new QName("DAV:", "prop"));
        List removeList = prop.getChildren();
        return removeList;
    }
}

