/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command.deltav;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.rest.Response;

public class CheckOutCommand {
    public Response checkout(Session session, String path) {
        try {
            Node node = session.getRootNode().getNode(TextUtil.relativizePath(path));
            if (node.isCheckedOut()) {
                return Response.Builder.withStatus((int)409).errorMessage("Node is already checkedout").build();
            }
            node.checkout();
            return Response.Builder.ok().build();
        }
        catch (UnsupportedRepositoryOperationException exc) {
            return Response.Builder.withStatus((int)409).errorMessage(exc.getMessage()).build();
        }
        catch (PathNotFoundException exc) {
            return Response.Builder.notFound().errorMessage(exc.getMessage()).build();
        }
        catch (LockException exc) {
            return Response.Builder.withStatus((int)423).errorMessage(exc.getMessage()).build();
        }
        catch (RepositoryException exc) {
            return Response.Builder.serverError().errorMessage(exc.getMessage()).build();
        }
    }
}

