/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav;

import java.io.InputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.logging.Log;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.webdav.Depth;
import org.exoplatform.services.jcr.webdav.PreconditionException;
import org.exoplatform.services.jcr.webdav.Range;
import org.exoplatform.services.jcr.webdav.WebDavService;
import org.exoplatform.services.jcr.webdav.command.CopyCommand;
import org.exoplatform.services.jcr.webdav.command.DeleteCommand;
import org.exoplatform.services.jcr.webdav.command.GetCommand;
import org.exoplatform.services.jcr.webdav.command.HeadCommand;
import org.exoplatform.services.jcr.webdav.command.LockCommand;
import org.exoplatform.services.jcr.webdav.command.MkColCommand;
import org.exoplatform.services.jcr.webdav.command.MoveCommand;
import org.exoplatform.services.jcr.webdav.command.OrderPatchCommand;
import org.exoplatform.services.jcr.webdav.command.PropFindCommand;
import org.exoplatform.services.jcr.webdav.command.PropPatchCommand;
import org.exoplatform.services.jcr.webdav.command.PutCommand;
import org.exoplatform.services.jcr.webdav.command.SearchCommand;
import org.exoplatform.services.jcr.webdav.command.UnLockCommand;
import org.exoplatform.services.jcr.webdav.command.deltav.CheckInCommand;
import org.exoplatform.services.jcr.webdav.command.deltav.CheckOutCommand;
import org.exoplatform.services.jcr.webdav.command.deltav.ReportCommand;
import org.exoplatform.services.jcr.webdav.command.deltav.UnCheckOutCommand;
import org.exoplatform.services.jcr.webdav.command.deltav.VersionControlCommand;
import org.exoplatform.services.jcr.webdav.lock.NullResourceLocksHolder;
import org.exoplatform.services.jcr.webdav.util.NodeTypeUtil;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.jcr.webdav.xml.XMLInputTransformer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.ContextParam;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.HeaderParam;
import org.exoplatform.services.rest.InputTransformer;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.QueryParam;
import org.exoplatform.services.rest.ResourceBinder;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.services.rest.container.ResourceDescriptor;
import org.exoplatform.services.rest.transformer.PassthroughInputTransformer;
import org.exoplatform.services.rest.transformer.PassthroughOutputTransformer;
import org.exoplatform.services.rest.transformer.SerializableTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@URITemplate(value="/jcr/")
public class WebDavServiceImpl
implements WebDavService,
ResourceContainer {
    public static final String INIT_PARAM_DEF_FOLDER_NODE_TYPE = "def-folder-node-type";
    public static final String INIT_PARAM_DEF_FILE_NODE_TYPE = "def-file-node-type";
    public static final String INIT_PARAM_DEF_FILE_MIME_TYPE = "def-file-mimetype";
    public static final String INIT_PARAM_UPDATE_POLICY = "update-policy";
    private static Log log = ExoLogger.getLogger((String)"jcr.WebDavServiceImpl");
    private final ThreadLocalSessionProviderService sessionProviderService;
    private final RepositoryService repositoryService;
    private final ResourceBinder resourceBinder;
    private final NullResourceLocksHolder nullResourceLocks;
    private String defaultFolderNodeType = "nt:folder";
    private String defaultFileNodeType = "nt:file";
    private String defaultFileMimeType = "application/octet-stream";
    private String updatePolicyType = "create-version";

    public WebDavServiceImpl(InitParams params, RepositoryService repositoryService, ThreadLocalSessionProviderService sessionProviderService, ResourceBinder resourceBinder) throws Exception {
        ValueParam pUpdatePolicy;
        ValueParam pDefFileMimeType;
        ValueParam pDefFileNodeType;
        this.sessionProviderService = sessionProviderService;
        this.repositoryService = repositoryService;
        this.resourceBinder = resourceBinder;
        this.nullResourceLocks = new NullResourceLocksHolder();
        ValueParam pDefFolderNodeType = params.getValueParam(INIT_PARAM_DEF_FOLDER_NODE_TYPE);
        if (pDefFolderNodeType != null) {
            this.defaultFolderNodeType = pDefFolderNodeType.getValue();
            log.info((Object)("def-folder-node-type = " + this.defaultFolderNodeType));
        }
        if ((pDefFileNodeType = params.getValueParam(INIT_PARAM_DEF_FILE_NODE_TYPE)) != null) {
            this.defaultFileNodeType = pDefFileNodeType.getValue();
            log.info((Object)("def-file-node-type = " + this.defaultFileNodeType));
        }
        if ((pDefFileMimeType = params.getValueParam(INIT_PARAM_DEF_FILE_MIME_TYPE)) != null) {
            this.defaultFileMimeType = pDefFileMimeType.getValue();
            log.info((Object)("def-file-mimetype = " + this.defaultFileMimeType));
        }
        if ((pUpdatePolicy = params.getValueParam(INIT_PARAM_UPDATE_POLICY)) != null) {
            this.updatePolicyType = pUpdatePolicy.getValue();
            log.info((Object)("update-policy = " + this.updatePolicyType));
        }
    }

    @Override
    @HTTPMethod(value="CHECKIN")
    @URITemplate(value="/{repoName}/{repoPath}/")
    @InputTransformer(value=XMLInputTransformer.class)
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response checkin(@URIParam(value="repoName") String repoName, @URIParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, HierarchicalProperty body) {
        Session session;
        log.debug((Object)("CHECKIN " + repoName + "/" + repoPath));
        repoPath = this.escapePath(repoPath);
        try {
            session = this.session(repoName, this.workspaceName(repoPath), this.lockTokens(lockTokenHeader, ifHeader));
        }
        catch (Exception exc) {
            return Response.Builder.serverError().errorMessage(exc.getMessage()).build();
        }
        return new CheckInCommand().checkIn(session, this.path(repoPath));
    }

    @Override
    @HTTPMethod(value="CHECKOUT")
    @URITemplate(value="/{repoName}/{repoPath}/")
    @InputTransformer(value=XMLInputTransformer.class)
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response checkout(@URIParam(value="repoName") String repoName, @URIParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, HierarchicalProperty body) {
        Session session;
        log.debug((Object)("CHECKOUT " + repoName + "/" + repoPath));
        repoPath = this.escapePath(repoPath);
        try {
            session = this.session(repoName, this.workspaceName(repoPath), this.lockTokens(lockTokenHeader, ifHeader));
        }
        catch (Exception exc) {
            return Response.Builder.serverError().errorMessage(exc.getMessage()).build();
        }
        return new CheckOutCommand().checkout(session, this.path(repoPath));
    }

    @Override
    @HTTPMethod(value="COPY")
    @URITemplate(value="/{repoName}/{repoPath}/")
    @InputTransformer(value=XMLInputTransformer.class)
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response copy(@URIParam(value="repoName") String repoName, @URIParam(value="repoPath") String repoPath, @HeaderParam(value="Destination") String destinationHeader, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, @HeaderParam(value="depth") String depthHeader, @HeaderParam(value="Overwrite") String overwriteHeader, @ContextParam(value="baseURI") String baseURI, HierarchicalProperty body) {
        log.debug((Object)("COPY " + repoName + "/" + repoPath));
        repoPath = this.escapePath(repoPath);
        try {
            String serverURI = baseURI + "/jcr/" + repoName;
            destinationHeader = TextUtil.unescape(destinationHeader, '%');
            if (!destinationHeader.startsWith(serverURI)) {
                return Response.Builder.withStatus((int)502).errorMessage("Bad Gateway").build();
            }
            String destPath = destinationHeader.substring(serverURI.length() + 1);
            String destWorkspace = this.workspaceName(destPath);
            String destinationPath = destinationHeader.substring(serverURI.length() + 1);
            List<String> lockTokens = this.lockTokens(lockTokenHeader, ifHeader);
            Depth depth = new Depth(depthHeader);
            if (overwriteHeader == null) {
                overwriteHeader = "F";
            }
            if (overwriteHeader.equalsIgnoreCase("T")) {
                this.delete(repoName, destinationPath, lockTokenHeader, ifHeader);
            } else {
                Session session = this.session(repoName, this.workspaceName(repoPath), null);
                String uri = baseURI + "/jcr/" + repoName + "/" + this.workspaceName(repoPath);
                Response prpfind = new PropFindCommand().propfind(session, this.path(destinationPath), body, depth.getIntValue(), uri);
                if (prpfind.getStatus() != 404) {
                    return Response.Builder.withStatus((int)412).build();
                }
            }
            if (depth.getStringValue().equalsIgnoreCase("infinity")) {
                String srcWorkspace = this.workspaceName(repoPath);
                if (srcWorkspace.equals(destWorkspace)) {
                    Session session = this.session(repoName, destWorkspace, lockTokens);
                    return new CopyCommand().copy(session, this.path(repoPath), this.path(destPath));
                }
                Session destSession = this.session(repoName, destWorkspace, lockTokens);
                return new CopyCommand().copy(destSession, srcWorkspace, this.path(repoPath), this.path(destPath));
            }
            if (depth.getIntValue() == 0) {
                int nodeNameStart = repoPath.lastIndexOf(47) + 1;
                String nodeName = repoPath.substring(nodeNameStart);
                Session session = this.session(repoName, destWorkspace, lockTokens);
                return new MkColCommand(this.nullResourceLocks).mkCol(session, this.path(destPath + "/" + nodeName), this.defaultFolderNodeType, null, lockTokens);
            }
            return Response.Builder.withStatus((int)400).errorMessage("Bad Request").build();
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return Response.Builder.serverError().errorMessage(exc.getMessage()).build();
        }
    }

    @Override
    @HTTPMethod(value="DELETE")
    @URITemplate(value="/{repoName}/{repoPath}/")
    @InputTransformer(value=PassthroughInputTransformer.class)
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response delete(@URIParam(value="repoName") String repoName, @URIParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader) {
        log.debug((Object)("DELETE " + repoName + "/" + repoPath));
        repoPath = this.escapePath(repoPath);
        try {
            Session session = this.session(repoName, this.workspaceName(repoPath), this.lockTokens(lockTokenHeader, ifHeader));
            return new DeleteCommand().delete(session, this.path(repoPath));
        }
        catch (NoSuchWorkspaceException e) {
            return Response.Builder.notFound().errorMessage(e.getMessage()).build();
        }
        catch (Exception exc) {
            return Response.Builder.serverError().errorMessage(exc.getMessage()).build();
        }
    }

    @Override
    @HTTPMethod(value="GET")
    @URITemplate(value="/{repoName}/{repoPath}/")
    @InputTransformer(value=PassthroughInputTransformer.class)
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response get(@URIParam(value="repoName") String repoName, @URIParam(value="repoPath") String repoPath, @HeaderParam(value="Range") String rangeHeader, @QueryParam(value="version") String version, @ContextParam(value="baseURI") String baseURI) {
        log.debug((Object)("GET " + repoName + "/" + repoPath));
        repoPath = this.escapePath(repoPath);
        try {
            Session session = this.session(repoName, this.workspaceName(repoPath), null);
            ArrayList<Range> ranges = new ArrayList<Range>();
            if (rangeHeader != null) {
                log.debug((Object)rangeHeader);
                if (rangeHeader.startsWith("bytes=")) {
                    String[] tokens;
                    String rangeString = rangeHeader.substring(rangeHeader.indexOf("=") + 1);
                    for (String token : tokens = rangeString.split(",")) {
                        Range range = new Range();
                        int dash = (token = token.trim()).indexOf("-");
                        if (dash == -1) {
                            return Response.Builder.withStatus((int)416).errorMessage("Requested Range Not Satisfiable").build();
                        }
                        if (dash == 0) {
                            range.setStart(Long.parseLong(token));
                            range.setEnd(-1L);
                        } else if (dash > 0) {
                            range.setStart(Long.parseLong(token.substring(0, dash)));
                            if (dash < token.length() - 1) {
                                range.setEnd(Long.parseLong(token.substring(dash + 1, token.length())));
                            } else {
                                range.setEnd(-1L);
                            }
                        }
                        ranges.add(range);
                    }
                }
            }
            String uri = baseURI + "/jcr/" + repoName + "/" + this.workspaceName(repoPath);
            return new GetCommand().get(session, this.path(repoPath), version, uri, ranges);
        }
        catch (PathNotFoundException e) {
            return Response.Builder.notFound().errorMessage(e.getMessage()).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.serverError().errorMessage(e.getMessage()).build();
        }
    }

    @Override
    @HTTPMethod(value="HEAD")
    @URITemplate(value="/{repoName}/{repoPath}/")
    @InputTransformer(value=PassthroughInputTransformer.class)
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response head(@URIParam(value="repoName") String repoName, @URIParam(value="repoPath") String repoPath, @QueryParam(value="version") String version, @ContextParam(value="baseURI") String baseURI) {
        log.debug((Object)("HEAD " + repoName + "/" + repoPath));
        repoPath = this.escapePath(repoPath);
        try {
            Session session = this.session(repoName, this.workspaceName(repoPath), null);
            String uri = baseURI + "/jcr/" + repoName + "/" + this.workspaceName(repoPath);
            return new HeadCommand().head(session, this.path(repoPath), uri);
        }
        catch (NoSuchWorkspaceException e) {
            return Response.Builder.notFound().errorMessage(e.getMessage()).build();
        }
        catch (Exception e) {
            return Response.Builder.serverError().errorMessage(e.getMessage()).build();
        }
    }

    @Override
    @HTTPMethod(value="LOCK")
    @URITemplate(value="/{repoName}/{repoPath}/")
    @InputTransformer(value=XMLInputTransformer.class)
    @OutputTransformer(value=SerializableTransformer.class)
    public Response lock(@URIParam(value="repoName") String repoName, @URIParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, @HeaderParam(value="depth") String depthHeader, @HeaderParam(value="Timeout") String timeout, HierarchicalProperty body) {
        log.debug((Object)("LOCK " + repoName + "/" + repoPath));
        repoPath = this.escapePath(repoPath);
        try {
            Session session = this.session(repoName, this.workspaceName(repoPath), this.lockTokens(lockTokenHeader, ifHeader));
            return new LockCommand(this.nullResourceLocks).lock(session, this.path(repoPath), body, new Depth(depthHeader), "86400");
        }
        catch (PreconditionException e) {
            log.error((Object)("PreconditionException " + e.getMessage()));
            e.printStackTrace();
            return Response.Builder.withStatus((int)412).errorMessage(e.getMessage()).build();
        }
        catch (NoSuchWorkspaceException e) {
            log.error((Object)("NoSuchWorkspaceException " + e.getMessage()));
            e.printStackTrace();
            return Response.Builder.notFound().errorMessage("Workspace not found for " + repoPath).build();
        }
        catch (Exception e) {
            log.error((Object)("Unhandled Exception " + e.getMessage()));
            e.printStackTrace();
            return Response.Builder.serverError().errorMessage(e.getMessage()).build();
        }
    }

    @Override
    @HTTPMethod(value="UNLOCK")
    @URITemplate(value="/{repoName}/{repoPath}/")
    @InputTransformer(value=XMLInputTransformer.class)
    @OutputTransformer(value=SerializableTransformer.class)
    public Response unlock(@URIParam(value="repoName") String repoName, @URIParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, HierarchicalProperty body) {
        log.debug((Object)("UNLOCK " + repoName + "/" + repoPath));
        repoPath = this.escapePath(repoPath);
        List<String> tokens = this.lockTokens(lockTokenHeader, ifHeader);
        try {
            Session session = this.session(repoName, this.workspaceName(repoPath), tokens);
            return new UnLockCommand(this.nullResourceLocks).unLock(session, this.path(repoPath), tokens);
        }
        catch (NoSuchWorkspaceException e) {
            return Response.Builder.notFound().errorMessage("Workspace not found for " + repoPath).build();
        }
        catch (Exception e) {
            return Response.Builder.serverError().errorMessage(e.getMessage()).build();
        }
    }

    @Override
    @HTTPMethod(value="MKCOL")
    @URITemplate(value="/{repoName}/{repoPath}/")
    @InputTransformer(value=PassthroughInputTransformer.class)
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response mkcol(@URIParam(value="repoName") String repoName, @URIParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, @HeaderParam(value="NodeType") String nodeTypeHeader, @HeaderParam(value="MixType") String mixinTypesHeader) {
        log.debug((Object)("MKCOL " + repoName + "/" + repoPath));
        repoPath = this.escapePath(repoPath);
        try {
            List<String> tokens = this.lockTokens(lockTokenHeader, ifHeader);
            Session session = this.session(repoName, this.workspaceName(repoPath), tokens);
            String nodeType = NodeTypeUtil.getNodeType(nodeTypeHeader);
            if (nodeType == null) {
                nodeType = this.defaultFolderNodeType;
            }
            return new MkColCommand(this.nullResourceLocks).mkCol(session, this.path(repoPath), nodeType, NodeTypeUtil.getMixinTypes(mixinTypesHeader), tokens);
        }
        catch (NoSuchWorkspaceException wexc) {
            return Response.Builder.notFound().build();
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return Response.Builder.serverError().errorMessage(exc.getMessage()).build();
        }
    }

    @Override
    @HTTPMethod(value="MOVE")
    @URITemplate(value="/{repoName}/{repoPath}/")
    @InputTransformer(value=XMLInputTransformer.class)
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response move(@URIParam(value="repoName") String repoName, @URIParam(value="repoPath") String repoPath, @HeaderParam(value="Destination") String destinationHeader, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, @HeaderParam(value="depth") String depthHeader, @HeaderParam(value="Overwrite") String overwriteHeader, @ContextParam(value="baseURI") String baseURI, HierarchicalProperty body) {
        log.debug((Object)("MOVE " + repoName + "/" + repoPath));
        repoPath = this.escapePath(repoPath);
        try {
            Session session;
            String serverURI = baseURI + "/jcr/" + repoName;
            destinationHeader = TextUtil.unescape(destinationHeader, '%');
            destinationHeader = serverURI + this.escapePath(destinationHeader.substring(serverURI.length()));
            if (!destinationHeader.startsWith(serverURI)) {
                return Response.Builder.withStatus((int)502).errorMessage("Bad Gateway").build();
            }
            String destPath = destinationHeader.substring(serverURI.length() + 1);
            String destWorkspace = this.workspaceName(destPath);
            String destinationPath = destinationHeader.substring(serverURI.length() + 1);
            String srcWorkspace = this.workspaceName(repoPath);
            List<String> lockTokens = this.lockTokens(lockTokenHeader, ifHeader);
            Depth depth = new Depth(depthHeader);
            if (overwriteHeader == null) {
                overwriteHeader = "F";
            }
            if (overwriteHeader.equalsIgnoreCase("T")) {
                this.delete(repoName, destinationPath, lockTokenHeader, ifHeader);
            } else {
                session = this.session(repoName, this.workspaceName(repoPath), null);
                String uri = baseURI + "/jcr/" + repoName + "/" + this.workspaceName(repoPath);
                Response prpfind = new PropFindCommand().propfind(session, this.path(destinationPath), body, depth.getIntValue(), uri);
                if (prpfind.getStatus() != 404) {
                    return Response.Builder.withStatus((int)412).build();
                }
            }
            if (depth.getStringValue().equalsIgnoreCase("Infinity")) {
                if (srcWorkspace.equals(destWorkspace)) {
                    session = this.session(repoName, srcWorkspace, lockTokens);
                    return new MoveCommand().move(session, this.path(repoPath), this.path(destPath));
                }
                Session srcSession = this.session(repoName, srcWorkspace, lockTokens);
                Session destSession = this.session(repoName, destWorkspace, lockTokens);
                return new MoveCommand().move(srcSession, destSession, this.path(repoPath), this.path(destPath));
            }
            return Response.Builder.withStatus((int)400).errorMessage("Bad Reuest").build();
        }
        catch (Exception e) {
            return Response.Builder.serverError().errorMessage(e.getMessage()).build();
        }
    }

    @Override
    @HTTPMethod(value="OPTIONS")
    @URITemplate(value="/{repoName}/")
    @InputTransformer(value=XMLInputTransformer.class)
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response options(@URIParam(value="repoName") String repoName, HierarchicalProperty body) {
        log.debug((Object)("OPTIONS " + repoName));
        ArrayList<String> commands = new ArrayList<String>();
        List descriptors = this.resourceBinder.getAllDescriptors();
        for (int i = 0; i < descriptors.size(); ++i) {
            ResourceDescriptor descriptor = (ResourceDescriptor)descriptors.get(i);
            String acceptableMethod = descriptor.getAcceptableMethod();
            String uriPattern = descriptor.getURIPattern().getString();
            if (!uriPattern.startsWith("/jcr/")) continue;
            commands.add(acceptableMethod);
        }
        String allowCommands = "";
        for (int i = 0; i < commands.size(); ++i) {
            String curCommand = (String)commands.get(i);
            allowCommands = allowCommands + curCommand;
            if (i >= commands.size() - 1) continue;
            allowCommands = allowCommands + ", ";
        }
        String DASL_VALUE = "<DAV:basicsearch><exo:sql xmlns:exo=\"http://exoplatform.com/jcr\"/><exo:xpath xmlns:exo=\"http://exoplatform.com/jcr\"/>";
        return Response.Builder.ok().header("Allow", allowCommands).header("DAV", "1, 2, ordered-collections").header("DASL", DASL_VALUE).header("MS-Author-Via", "DAV").build();
    }

    @Override
    @HTTPMethod(value="ORDERPATCH")
    @URITemplate(value="/{repoName}/{repoPath}/")
    @InputTransformer(value=XMLInputTransformer.class)
    @OutputTransformer(value=SerializableTransformer.class)
    public Response order(@URIParam(value="repoName") String repoName, @URIParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, @ContextParam(value="baseURI") String baseURI, HierarchicalProperty body) {
        log.debug((Object)("ORDERPATCH " + repoName + "/" + repoPath));
        repoPath = this.escapePath(repoPath);
        try {
            List<String> lockTokens = this.lockTokens(lockTokenHeader, ifHeader);
            Session session = this.session(repoName, this.workspaceName(repoPath), lockTokens);
            String uri = baseURI + "/jcr/" + repoName + "/" + this.workspaceName(repoPath);
            return new OrderPatchCommand().orderPatch(session, this.path(repoPath), body, uri);
        }
        catch (Exception e) {
            return Response.Builder.serverError().errorMessage(e.getMessage()).build();
        }
    }

    @Override
    @HTTPMethod(value="PROPFIND")
    @URITemplate(value="/{repoName}/{repoPath}/")
    @InputTransformer(value=XMLInputTransformer.class)
    @OutputTransformer(value=SerializableTransformer.class)
    public Response propfind(@URIParam(value="repoName") String repoName, @URIParam(value="repoPath") String repoPath, @HeaderParam(value="depth") String depthHeader, @ContextParam(value="baseURI") String baseURI, HierarchicalProperty body) {
        log.debug((Object)("PROPFIND " + repoName + "/" + repoPath));
        repoPath = this.escapePath(repoPath);
        try {
            Session session = this.session(repoName, this.workspaceName(repoPath), null);
            String uri = baseURI + "/jcr/" + repoName + "/" + this.workspaceName(repoPath);
            Depth depth = new Depth(depthHeader);
            return new PropFindCommand().propfind(session, this.path(repoPath), body, depth.getIntValue(), uri);
        }
        catch (NoSuchWorkspaceException e) {
            e.printStackTrace();
            return Response.Builder.notFound().errorMessage(e.getMessage()).build();
        }
        catch (PreconditionException e) {
            e.printStackTrace();
            return Response.Builder.badRequest().errorMessage(e.getMessage()).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.Builder.serverError().errorMessage(e.getMessage()).build();
        }
    }

    @Override
    @HTTPMethod(value="PROPPATCH")
    @URITemplate(value="/{repoName}/{repoPath}/")
    @InputTransformer(value=XMLInputTransformer.class)
    @OutputTransformer(value=SerializableTransformer.class)
    public Response proppatch(@URIParam(value="repoName") String repoName, @URIParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, @ContextParam(value="baseURI") String baseURI, HierarchicalProperty body) {
        log.debug((Object)("PROPPATCH " + repoName + "/" + repoPath));
        repoPath = this.escapePath(repoPath);
        try {
            List<String> lockTokens = this.lockTokens(lockTokenHeader, ifHeader);
            Session session = this.session(repoName, this.workspaceName(repoPath), lockTokens);
            String uri = baseURI + "/jcr/" + repoName + "/" + this.workspaceName(repoPath);
            return new PropPatchCommand(this.nullResourceLocks).propPatch(session, this.path(repoPath), body, lockTokens, uri);
        }
        catch (NoSuchWorkspaceException exc) {
            log.error((Object)("NoSuchWorkspace. " + exc.getMessage()));
            return Response.Builder.notFound().errorMessage(exc.getMessage()).build();
        }
        catch (Exception exc) {
            log.error((Object)("Unhandled exception. " + exc.getMessage()));
            return Response.Builder.serverError().errorMessage(exc.getMessage()).build();
        }
    }

    @Override
    @HTTPMethod(value="PUT")
    @URITemplate(value="/{repoName}/{repoPath}/")
    @InputTransformer(value=PassthroughInputTransformer.class)
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response put(@URIParam(value="repoName") String repoName, @URIParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, @HeaderParam(value="NodeType") String nodeTypeHeader, @HeaderParam(value="MixType") String mixinTypesHeader, @HeaderParam(value="Content-type") String mimeType, InputStream inputStream) {
        log.debug((Object)("PUT " + repoName + "/" + repoPath));
        repoPath = this.escapePath(repoPath);
        try {
            List<String> tokens = this.lockTokens(lockTokenHeader, ifHeader);
            Session session = this.session(repoName, this.workspaceName(repoPath), tokens);
            String fileNodeType = NodeTypeUtil.getNodeType(nodeTypeHeader);
            if (fileNodeType == null) {
                fileNodeType = this.defaultFileNodeType;
            }
            if (mimeType == null) {
                MimeTypeResolver mimeTypeResolver = new MimeTypeResolver();
                mimeTypeResolver.setDefaultMimeType(this.defaultFileMimeType);
                mimeType = mimeTypeResolver.getMimeType(TextUtil.nameOnly(repoPath));
            }
            return new PutCommand(this.nullResourceLocks).put(session, this.path(repoPath), inputStream, fileNodeType, mimeType, this.updatePolicyType, tokens);
        }
        catch (NoSuchWorkspaceException exc) {
            return Response.Builder.notFound().errorMessage(exc.getMessage()).build();
        }
        catch (Exception e) {
            return Response.Builder.serverError().errorMessage(e.getMessage()).build();
        }
    }

    @Override
    @HTTPMethod(value="REPORT")
    @URITemplate(value="/{repoName}/{repoPath}/")
    @InputTransformer(value=XMLInputTransformer.class)
    @OutputTransformer(value=SerializableTransformer.class)
    public Response report(@URIParam(value="repoName") String repoName, @URIParam(value="repoPath") String repoPath, @HeaderParam(value="depth") String depthHeader, @ContextParam(value="baseURI") String baseURI, HierarchicalProperty body) {
        log.debug((Object)("REPORT " + repoName + "/" + repoPath));
        repoPath = this.escapePath(repoPath);
        try {
            Depth depth = new Depth(depthHeader);
            Session session = this.session(repoName, this.workspaceName(repoPath), null);
            String uri = baseURI + "/jcr/" + repoName + "/" + this.workspaceName(repoPath);
            return new ReportCommand().report(session, this.path(repoPath), body, depth, uri);
        }
        catch (NoSuchWorkspaceException e) {
            return Response.Builder.notFound().errorMessage(e.getMessage()).build();
        }
        catch (Exception e) {
            return Response.Builder.serverError().errorMessage(e.getMessage()).build();
        }
    }

    @Override
    @HTTPMethod(value="SEARCH")
    @URITemplate(value="/{repoName}/{repoPath}/")
    @InputTransformer(value=XMLInputTransformer.class)
    @OutputTransformer(value=SerializableTransformer.class)
    public Response search(@URIParam(value="repoName") String repoName, @URIParam(value="repoPath") String repoPath, @ContextParam(value="baseURI") String baseURI, HierarchicalProperty body) {
        log.debug((Object)("SEARCH " + repoName + "/" + repoPath));
        repoPath = this.escapePath(repoPath);
        try {
            Session session = this.session(repoName, this.workspaceName(repoPath), null);
            String uri = baseURI + "/jcr/" + repoName + "/" + this.workspaceName(repoPath);
            return new SearchCommand().search(session, body, uri);
        }
        catch (NoSuchWorkspaceException exc) {
            return Response.Builder.notFound().errorMessage(exc.getMessage()).build();
        }
        catch (Exception exc) {
            return Response.Builder.serverError().errorMessage(exc.getMessage()).build();
        }
    }

    @Override
    @HTTPMethod(value="UNCHECKOUT")
    @URITemplate(value="/{repoName}/{repoPath}/")
    @InputTransformer(value=XMLInputTransformer.class)
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response uncheckout(@URIParam(value="repoName") String repoName, @URIParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, HierarchicalProperty body) {
        log.debug((Object)("UNCHECKOUT " + repoName + "/" + repoPath));
        repoPath = this.escapePath(repoPath);
        try {
            Session session = this.session(repoName, this.workspaceName(repoPath), this.lockTokens(lockTokenHeader, ifHeader));
            return new UnCheckOutCommand().uncheckout(session, this.path(repoPath));
        }
        catch (NoSuchWorkspaceException e) {
            return Response.Builder.notFound().errorMessage(e.getMessage()).build();
        }
        catch (Exception e) {
            return Response.Builder.serverError().errorMessage(e.getMessage()).build();
        }
    }

    @Override
    @HTTPMethod(value="VERSION-CONTROL")
    @URITemplate(value="/{repoName}/{repoPath}/")
    @InputTransformer(value=PassthroughInputTransformer.class)
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response versionControl(@URIParam(value="repoName") String repoName, @URIParam(value="repoPath") String repoPath, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader) {
        Session session;
        log.debug((Object)("VERSION-CONTROL " + repoName + "/" + repoPath));
        repoPath = this.escapePath(repoPath);
        try {
            session = this.session(repoName, this.workspaceName(repoPath), this.lockTokens(lockTokenHeader, ifHeader));
        }
        catch (Exception e) {
            return Response.Builder.serverError().errorMessage(e.getMessage()).build();
        }
        return new VersionControlCommand().versionControl(session, this.path(repoPath));
    }

    protected Session session(String repoName, String wsName, List<String> lockTokens) throws Exception {
        ManageableRepository repo = this.repositoryService.getRepository(repoName);
        SessionProvider sp = this.sessionProviderService.getSessionProvider(null);
        if (sp == null) {
            throw new RepositoryException("SessionProvider is not properly set. Make the application callsSessionProviderService.setSessionProvider(..) somewhere before (for instance in Servlet Filter for WEB application)");
        }
        Session session = sp.getSession(wsName, repo);
        if (lockTokens != null) {
            int i;
            String[] presentLockTokens = session.getLockTokens();
            ArrayList<String> presentLockTokensList = new ArrayList<String>();
            for (i = 0; i < presentLockTokens.length; ++i) {
                presentLockTokensList.add(presentLockTokens[i]);
            }
            for (i = 0; i < lockTokens.size(); ++i) {
                String lockToken = lockTokens.get(i);
                if (presentLockTokensList.contains(lockToken)) continue;
                session.addLockToken(lockToken);
            }
        }
        return session;
    }

    protected String workspaceName(String repoPath) {
        return repoPath.split("/")[0];
    }

    private String escapePath(String repoPath) {
        String[] pathElements = repoPath.split("/");
        StringBuffer escapedPath = new StringBuffer();
        for (String element : pathElements) {
            try {
                if (element.contains("'")) {
                    element = element.replaceAll("'", URLEncoder.encode("'", "UTF-8"));
                }
                escapedPath.append(element + "/");
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage());
            }
        }
        return escapedPath.toString().substring(0, escapedPath.length() - 1);
    }

    protected String path(String repoPath) {
        String path = repoPath.substring(this.workspaceName(repoPath).length(), repoPath.length());
        if (!"".equals(path)) {
            return path;
        }
        return "/";
    }

    protected List<String> lockTokens(String lockTokenHeader, String ifHeader) {
        ArrayList<String> lockTokens = new ArrayList<String>();
        if (lockTokenHeader != null) {
            lockTokenHeader = lockTokenHeader.substring(1, lockTokenHeader.length() - 1);
            lockTokens.add(lockTokenHeader);
        }
        if (ifHeader != null) {
            String headerLockToken = ifHeader.substring(ifHeader.indexOf("("));
            headerLockToken = headerLockToken.substring(2, headerLockToken.length() - 2);
            lockTokens.add(headerLockToken);
        }
        return lockTokens;
    }
}

