/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import org.exoplatform.services.rest.Response;

public class CopyCommand {
    public Response copy(Session destSession, String sourcePath, String destPath) {
        try {
            destSession.getWorkspace().copy(sourcePath, destPath);
            return Response.Builder.withStatus((int)201).build();
        }
        catch (ItemExistsException e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)405).errorMessage(e.getMessage()).build();
        }
        catch (PathNotFoundException e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)409).errorMessage(e.getMessage()).build();
        }
        catch (AccessDeniedException e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)403).errorMessage(e.getMessage()).build();
        }
        catch (LockException e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)423).errorMessage(e.getMessage()).build();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return Response.Builder.serverError().errorMessage(e.getMessage()).build();
        }
    }

    public Response copy(Session destSession, String sourceWorkspace, String sourcePath, String destPath) {
        try {
            destSession.getWorkspace().copy(sourceWorkspace, sourcePath, destPath);
            return Response.Builder.withStatus((int)201).build();
        }
        catch (ItemExistsException e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)405).errorMessage(e.getMessage()).build();
        }
        catch (PathNotFoundException e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)409).errorMessage(e.getMessage()).build();
        }
        catch (AccessDeniedException e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)403).errorMessage(e.getMessage()).build();
        }
        catch (LockException e) {
            e.printStackTrace();
            return Response.Builder.withStatus((int)423).errorMessage(e.getMessage()).build();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return Response.Builder.serverError().errorMessage(e.getMessage()).build();
        }
    }
}

