/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.services.rest.transformer.InputEntityTransformer;

public class XMLInputTransformer
extends InputEntityTransformer {
    private Stack<HierarchicalProperty> curProperty = new Stack();
    private HierarchicalProperty rootProperty;

    public XMLInputTransformer() {
        super(new Object[0]);
    }

    public Object readFrom(InputStream stream) throws IOException {
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLEventReader reader = factory.createXMLEventReader(stream);
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                switch (event.getEventType()) {
                    case 1: {
                        StartElement element = event.asStartElement();
                        QName name = element.getName();
                        HierarchicalProperty prop = new HierarchicalProperty(name);
                        if (!this.curProperty.empty()) {
                            this.curProperty.peek().addChild(prop);
                        } else {
                            this.rootProperty = prop;
                        }
                        this.curProperty.push(prop);
                        break;
                    }
                    case 2: {
                        this.curProperty.pop();
                        break;
                    }
                    case 4: {
                        String chars = event.asCharacters().getData();
                        this.curProperty.peek().setValue(chars);
                        break;
                    }
                }
            }
            return this.rootProperty;
        }
        catch (FactoryConfigurationError e) {
            throw new IOException(e.getMessage());
        }
        catch (XMLStreamException e) {
            return null;
        }
    }
}

