/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;

public class CopyCommand {
    private static Log log = ExoLogger.getLogger(CopyCommand.class);

    public Response copy(Session destSession, String sourcePath, String destPath) {
        try {
            destSession.getWorkspace().copy(sourcePath, destPath);
            return Response.status((int)201).build();
        }
        catch (ItemExistsException e) {
            return Response.status((int)405).build();
        }
        catch (PathNotFoundException e) {
            return Response.status((int)409).build();
        }
        catch (AccessDeniedException e) {
            return Response.status((int)403).build();
        }
        catch (LockException e) {
            return Response.status((int)423).build();
        }
        catch (RepositoryException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return Response.serverError().build();
        }
    }

    public Response copy(Session destSession, String sourceWorkspace, String sourcePath, String destPath) {
        try {
            destSession.getWorkspace().copy(sourceWorkspace, sourcePath, destPath);
            return Response.status((int)201).build();
        }
        catch (ItemExistsException e) {
            return Response.status((int)405).build();
        }
        catch (PathNotFoundException e) {
            return Response.status((int)409).build();
        }
        catch (AccessDeniedException e) {
            return Response.status((int)403).build();
        }
        catch (LockException e) {
            return Response.status((int)423).build();
        }
        catch (RepositoryException e) {
            return Response.serverError().build();
        }
    }
}

