/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.lnkproducer;

import java.io.IOException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.webdav.lnkproducer.LinkGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/lnkproducer/")
public class LnkProducer
implements ResourceContainer {
    private static Log log = ExoLogger.getLogger(LnkProducer.class);

    @GET
    @Path(value="/{linkFilePath}/")
    @Produces(value={"application/octet-stream"})
    public Response produceLink(@PathParam(value="linkFilePath") String linkFilePath, @QueryParam(value="path") String path, @Context UriInfo uriInfo) {
        String host = uriInfo.getRequestUri().getHost();
        String uri = uriInfo.getBaseUri().toString();
        try {
            LinkGenerator linkGenerator = new LinkGenerator(host, uri, path);
            byte[] content = linkGenerator.generateLinkContent();
            return Response.ok((Object)content, (String)"application/octet-stream").header("Content-Length", (Object)Integer.toString(content.length)).build();
        }
        catch (IOException exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            throw new WebApplicationException((Throwable)exc);
        }
    }
}

