/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import java.net.URI;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.ws.rs.core.Response;
import org.exoplatform.services.jcr.webdav.resource.FileResource;
import org.exoplatform.services.jcr.webdav.resource.ResourceUtil;
import org.exoplatform.services.jcr.webdav.util.PropertyConstants;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.jcr.webdav.xml.WebDavNamespaceContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class HeadCommand {
    private static Log log = ExoLogger.getLogger(HeadCommand.class);

    public Response head(Session session, String path, String baseURI) {
        try {
            Node node = (Node)session.getItem(path);
            WebDavNamespaceContext nsContext = new WebDavNamespaceContext(session);
            URI uri = new URI(TextUtil.escape(baseURI + node.getPath(), '%', true));
            if (ResourceUtil.isFile(node)) {
                FileResource resource = new FileResource(uri, node, nsContext);
                String lastModified = resource.getProperty(PropertyConstants.GETLASTMODIFIED).getValue();
                String contentType = resource.getProperty(PropertyConstants.GETCONTENTTYPE).getValue();
                String contentLength = resource.getProperty(PropertyConstants.GETCONTENTLENGTH).getValue();
                return Response.ok().header("Last-Modified", (Object)lastModified).header("Content-Type", (Object)contentType).header("Content-Length", (Object)contentLength).build();
            }
            return Response.ok().build();
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().build();
        }
    }
}

