/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class MoveCommand {
    private static CacheControl cacheControl = new CacheControl();
    private static Log log = ExoLogger.getLogger(MoveCommand.class);

    public Response move(Session session, String srcPath, String destPath) {
        try {
            boolean itemExisted = session.itemExists(destPath);
            if (itemExisted) {
                session.getItem(destPath).remove();
            }
            session.move(srcPath, destPath);
            session.save();
            if (itemExisted) {
                return Response.status((int)204).cacheControl(cacheControl).build();
            }
            return Response.status((int)201).cacheControl(cacheControl).build();
        }
        catch (LockException exc) {
            return Response.status((int)423).build();
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)409).build();
        }
        catch (RepositoryException exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().build();
        }
    }

    public Response move(Session sourceSession, Session destSession, String srcPath, String destPath) {
        try {
            destSession.getWorkspace().copy(sourceSession.getWorkspace().getName(), srcPath, destPath);
            sourceSession.getItem(srcPath).remove();
            sourceSession.save();
            return Response.status((int)204).cacheControl(cacheControl).build();
        }
        catch (LockException exc) {
            return Response.status((int)423).build();
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)409).build();
        }
        catch (RepositoryException exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().build();
        }
    }

    static {
        cacheControl.setNoCache(true);
    }
}

