/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import java.io.InputStream;
import java.net.URI;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.ws.rs.core.Response;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.services.jcr.webdav.Range;
import org.exoplatform.services.jcr.webdav.resource.CollectionResource;
import org.exoplatform.services.jcr.webdav.resource.FileResource;
import org.exoplatform.services.jcr.webdav.resource.GenericResource;
import org.exoplatform.services.jcr.webdav.resource.ResourceUtil;
import org.exoplatform.services.jcr.webdav.resource.VersionResource;
import org.exoplatform.services.jcr.webdav.resource.VersionedFileResource;
import org.exoplatform.services.jcr.webdav.util.MultipartByterangesEntity;
import org.exoplatform.services.jcr.webdav.util.RangedInputStream;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.jcr.webdav.xml.WebDavNamespaceContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.ext.provider.XSLTStreamingOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetCommand {
    private static Log log = ExoLogger.getLogger(GetCommand.class);

    public Response get(Session session, String path, String version, String baseURI, List<Range> ranges) {
        if (null == version && path.indexOf("?version=") > 0) {
            version = path.substring(path.indexOf("?version=") + "?version=".length());
            path = path.substring(0, path.indexOf("?version="));
        }
        try {
            Node node = (Node)session.getItem(path);
            WebDavNamespaceContext nsContext = new WebDavNamespaceContext(session);
            URI uri = new URI(TextUtil.escape(baseURI + node.getPath(), '%', true));
            if (ResourceUtil.isFile(node)) {
                InputStream istream;
                GenericResource resource;
                if (version != null) {
                    VersionedFileResource versionedFile = new VersionedFileResource(uri, node, nsContext);
                    resource = versionedFile.getVersionHistory().getVersion(version);
                    istream = ((VersionResource)resource).getContentAsStream();
                } else {
                    resource = new FileResource(uri, node, nsContext);
                    istream = ((FileResource)resource).getContentAsStream();
                }
                HierarchicalProperty contentLengthProperty = resource.getProperty(FileResource.GETCONTENTLENGTH);
                long contentLength = new Long(contentLengthProperty.getValue());
                HierarchicalProperty mimeTypeProperty = resource.getProperty(FileResource.GETCONTENTTYPE);
                String contentType = mimeTypeProperty.getValue();
                if (contentLength == 0L) {
                    return Response.ok().header("Accept-Ranges", (Object)"bytes").entity((Object)istream).build();
                }
                if (ranges.size() == 0) {
                    return Response.ok().header("Content-Length", (Object)Long.toString(contentLength)).header("Accept-Ranges", (Object)"bytes").entity((Object)istream).type(contentType).build();
                }
                if (ranges.size() == 1) {
                    Range range = ranges.get(0);
                    if (!this.validateRange(range, contentLength)) {
                        return Response.status((int)416).header("Content-Range", (Object)("bytes */" + contentLength)).build();
                    }
                    long start = range.getStart();
                    long end = range.getEnd();
                    long returnedContentLength = end - start + 1L;
                    RangedInputStream rangedInputStream = new RangedInputStream(istream, start, end);
                    return Response.status((int)206).header("Content-Length", (Object)Long.toString(returnedContentLength)).header("Accept-Ranges", (Object)"bytes").header("Content-Range", (Object)("bytes " + start + "-" + end + "/" + contentLength)).entity((Object)rangedInputStream).build();
                }
                for (int i = 0; i < ranges.size(); ++i) {
                    Range range = ranges.get(i);
                    if (!this.validateRange(range, contentLength)) {
                        return Response.status((int)416).header("Content-Range", (Object)("bytes */" + contentLength)).build();
                    }
                    ranges.set(i, range);
                }
                MultipartByterangesEntity mByterangesEntity = new MultipartByterangesEntity(resource, ranges, contentType, contentLength);
                return Response.status((int)206).header("Accept-Ranges", (Object)"bytes").entity((Object)mByterangesEntity).build();
            }
            CollectionResource resource = new CollectionResource(uri, node, nsContext);
            InputStream istream = resource.getContentAsStream(baseURI);
            XSLTStreamingOutput entity = new XSLTStreamingOutput("get.method.template", (Source)new StreamSource(istream));
            return Response.ok((Object)entity, (String)"text/html").build();
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).build();
        }
        catch (RepositoryException exc) {
            return Response.serverError().build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().build();
        }
    }

    private boolean validateRange(Range range, long contentLength) {
        long start = range.getStart();
        long end = range.getEnd();
        if (start < 0L && end == -1L) {
            if (-1L * start >= contentLength) {
                start = 0L;
                end = contentLength - 1L;
            } else {
                start = contentLength + start;
                end = contentLength - 1L;
            }
        }
        if (start >= 0L && end == -1L) {
            end = contentLength - 1L;
        }
        if (end >= contentLength) {
            end = contentLength - 1L;
        }
        if (start >= 0L && end >= 0L && start <= end) {
            range.setStart(start);
            range.setEnd(end);
            return true;
        }
        return false;
    }
}

