/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.ws.rs.core.Response;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.services.jcr.webdav.command.proppatch.PropPatchResponseEntity;
import org.exoplatform.services.jcr.webdav.lock.NullResourceLocksHolder;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.jcr.webdav.xml.WebDavNamespaceContext;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropPatchCommand {
    private static Log log = ExoLogger.getLogger(PropPatchCommand.class);
    protected final NullResourceLocksHolder lockHolder;

    public PropPatchCommand(NullResourceLocksHolder lockHolder) {
        this.lockHolder = lockHolder;
    }

    public Response propPatch(Session session, String path, HierarchicalProperty body, List<String> tokens, String baseURI) {
        try {
            this.lockHolder.checkLock(session, path, tokens);
            Node node = (Node)session.getItem(path);
            WebDavNamespaceContext nsContext = new WebDavNamespaceContext(session);
            URI uri = new URI(TextUtil.escape(baseURI + node.getPath(), '%', true));
            List<HierarchicalProperty> setList = Collections.emptyList();
            if (body.getChild(new QName("DAV:", "set")) != null) {
                setList = this.setList(body);
            }
            List<HierarchicalProperty> removeList = Collections.emptyList();
            if (body.getChild(new QName("DAV:", "remove")) != null) {
                removeList = this.removeList(body);
            }
            PropPatchResponseEntity entity = new PropPatchResponseEntity(nsContext, node, uri, setList, removeList);
            return Response.status((int)207).entity((Object)entity).type("text/xml").build();
        }
        catch (PathNotFoundException exc) {
            return Response.status((int)404).build();
        }
        catch (LockException exc) {
            return Response.status((int)423).build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().build();
        }
    }

    public List<HierarchicalProperty> setList(HierarchicalProperty request) {
        HierarchicalProperty set = request.getChild(new QName("DAV:", "set"));
        HierarchicalProperty prop = set.getChild(new QName("DAV:", "prop"));
        List setList = prop.getChildren();
        return setList;
    }

    public List<HierarchicalProperty> removeList(HierarchicalProperty request) {
        HierarchicalProperty remove = request.getChild(new QName("DAV:", "remove"));
        HierarchicalProperty prop = remove.getChild(new QName("DAV:", "prop"));
        List removeList = prop.getChildren();
        return removeList;
    }
}

