/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.webdav.lock.NullResourceLocksHolder;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnLockCommand {
    private static Log log = ExoLogger.getLogger(UnLockCommand.class);
    protected final NullResourceLocksHolder nullResourceLocks;

    public UnLockCommand(NullResourceLocksHolder nullResourceLocks) {
        this.nullResourceLocks = nullResourceLocks;
    }

    public Response unLock(Session session, String path, List<String> tokens) {
        try {
            try {
                Node node = (Node)session.getItem(path);
                if (node.isLocked()) {
                    node.unlock();
                    session.save();
                }
                return Response.status((int)204).build();
            }
            catch (PathNotFoundException exc) {
                if (this.nullResourceLocks.isLocked(session, path)) {
                    this.nullResourceLocks.checkLock(session, path, tokens);
                    this.nullResourceLocks.removeLock(session, path);
                    return Response.status((int)204).build();
                }
                return Response.status((int)404).build();
            }
        }
        catch (LockException exc) {
            return Response.status((int)423).build();
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            return Response.serverError().build();
        }
    }
}

