/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command.proppatch;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.ws.rs.core.StreamingOutput;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.services.jcr.webdav.WebDavConst;
import org.exoplatform.services.jcr.webdav.util.PropertyConstants;
import org.exoplatform.services.jcr.webdav.xml.PropertyWriteUtil;
import org.exoplatform.services.jcr.webdav.xml.WebDavNamespaceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropPatchResponseEntity
implements StreamingOutput {
    private final WebDavNamespaceContext nsContext;
    private Node node;
    private final URI uri;
    private final List<HierarchicalProperty> setList;
    private final List<HierarchicalProperty> removeList;
    protected static final Set<QName> NON_REMOVING_PROPS = new HashSet<QName>();

    public PropPatchResponseEntity(WebDavNamespaceContext nsContext, Node node, URI uri, List<HierarchicalProperty> setList, List<HierarchicalProperty> removeList) {
        this.nsContext = nsContext;
        this.node = node;
        this.uri = uri;
        this.setList = setList;
        this.removeList = removeList;
    }

    public void write(OutputStream outStream) throws IOException {
        try {
            XMLStreamWriter xmlStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(outStream, "UTF-8");
            xmlStreamWriter.setNamespaceContext(this.nsContext);
            xmlStreamWriter.setDefaultNamespace("DAV:");
            xmlStreamWriter.writeStartDocument();
            xmlStreamWriter.writeStartElement("D", "multistatus", "DAV:");
            xmlStreamWriter.writeNamespace("D", "DAV:");
            xmlStreamWriter.writeAttribute("xmlns:b", "urn:uuid:c2f41010-65b3-11d1-a29f-00aa00c14882/");
            xmlStreamWriter.writeStartElement("DAV:", "response");
            xmlStreamWriter.writeStartElement("DAV:", "href");
            xmlStreamWriter.writeCharacters(this.uri.toASCIIString());
            xmlStreamWriter.writeEndElement();
            Map<String, Set<HierarchicalProperty>> propStats = this.getPropStat();
            PropertyWriteUtil.writePropStats(xmlStreamWriter, propStats);
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndDocument();
        }
        catch (XMLStreamException exc) {
            throw new IOException(exc.getMessage());
        }
    }

    protected Map<String, Set<HierarchicalProperty>> getPropStat() {
        Set propSet;
        String statname;
        String propertyName;
        int i;
        HashMap<String, Set<HierarchicalProperty>> propStats = new HashMap<String, Set<HierarchicalProperty>>();
        for (i = 0; i < this.setList.size(); ++i) {
            HierarchicalProperty setProperty = this.setList.get(i);
            try {
                propertyName = WebDavNamespaceContext.createName(setProperty.getName());
                try {
                    this.node.setProperty(propertyName, setProperty.getValue());
                    this.node.save();
                }
                catch (RepositoryException exc) {
                    String[] value = new String[]{setProperty.getValue()};
                    this.node.setProperty(propertyName, value);
                    this.node.save();
                }
                statname = WebDavConst.getStatusDescription(200);
            }
            catch (AccessDeniedException e) {
                statname = WebDavConst.getStatusDescription(403);
            }
            catch (ItemNotFoundException e) {
                statname = WebDavConst.getStatusDescription(404);
            }
            catch (PathNotFoundException e) {
                statname = WebDavConst.getStatusDescription(404);
            }
            catch (RepositoryException e) {
                statname = WebDavConst.getStatusDescription(409);
            }
            if (!propStats.containsKey(statname)) {
                propStats.put(statname, new HashSet());
            }
            propSet = (Set)propStats.get(statname);
            propSet.add(new HierarchicalProperty(setProperty.getName()));
        }
        for (i = 0; i < this.removeList.size(); ++i) {
            HierarchicalProperty removeProperty = this.removeList.get(i);
            try {
                if (NON_REMOVING_PROPS.contains(removeProperty.getName())) {
                    statname = WebDavConst.getStatusDescription(409);
                    if (!propStats.containsKey(statname)) {
                        propStats.put(statname, new HashSet());
                    }
                    propSet = (Set)propStats.get(statname);
                    propSet.add(new HierarchicalProperty(removeProperty.getName()));
                    continue;
                }
                propertyName = WebDavNamespaceContext.createName(removeProperty.getName());
                Property property = this.node.getProperty(propertyName);
                property.remove();
                property.save();
                statname = WebDavConst.getStatusDescription(200);
            }
            catch (AccessDeniedException e) {
                statname = WebDavConst.getStatusDescription(403);
            }
            catch (ItemNotFoundException e) {
                statname = WebDavConst.getStatusDescription(404);
            }
            catch (PathNotFoundException e) {
                statname = WebDavConst.getStatusDescription(404);
            }
            catch (RepositoryException e) {
                statname = WebDavConst.getStatusDescription(409);
            }
            if (!propStats.containsKey(statname)) {
                propStats.put(statname, new HashSet());
            }
            propSet = (Set)propStats.get(statname);
            propSet.add(new HierarchicalProperty(removeProperty.getName()));
        }
        return propStats;
    }

    public Node contentNode() throws RepositoryException {
        return this.node.getNode("jcr:content");
    }

    static {
        NON_REMOVING_PROPS.add(PropertyConstants.CREATIONDATE);
        NON_REMOVING_PROPS.add(PropertyConstants.DISPLAYNAME);
        NON_REMOVING_PROPS.add(PropertyConstants.GETCONTENTLANGUAGE);
        NON_REMOVING_PROPS.add(PropertyConstants.GETCONTENTLENGTH);
        NON_REMOVING_PROPS.add(PropertyConstants.GETCONTENTTYPE);
        NON_REMOVING_PROPS.add(PropertyConstants.GETLASTMODIFIED);
    }
}

