/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import java.io.InputStream;
import java.util.Calendar;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.ws.rs.core.Response;
import org.exoplatform.services.jcr.webdav.lock.NullResourceLocksHolder;
import org.exoplatform.services.jcr.webdav.util.TextUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PutCommand {
    private final NullResourceLocksHolder nullResourceLocks;

    public PutCommand(NullResourceLocksHolder nullResourceLocks) {
        this.nullResourceLocks = nullResourceLocks;
    }

    public Response put(Session session, String path, InputStream inputStream, String fileNodeType, String contentNodeType, List<String> mixins, String mimeType, String updatePolicyType, List<String> tokens) {
        try {
            Node node = null;
            try {
                node = (Node)session.getItem(path);
            }
            catch (PathNotFoundException pexc) {
                this.nullResourceLocks.checkLock(session, path, tokens);
            }
            if (node == null || "add".equals(updatePolicyType)) {
                node = session.getRootNode().addNode(TextUtil.relativizePath(path), fileNodeType);
                node.addNode("jcr:content", contentNodeType);
                this.updateContent(node, inputStream, mimeType, mixins);
            } else if ("add".equals(updatePolicyType)) {
                node = session.getRootNode().addNode(TextUtil.relativizePath(path), fileNodeType);
                node.addNode("jcr:content", contentNodeType);
                this.updateContent(node, inputStream, mimeType, mixins);
            } else if ("create-version".equals(updatePolicyType)) {
                this.createVersion(node, inputStream, mimeType, mixins);
            } else {
                this.updateContent(node, inputStream, mimeType, mixins);
            }
            session.save();
        }
        catch (LockException exc) {
            return Response.status((int)423).build();
        }
        catch (AccessDeniedException e) {
            return Response.status((int)403).build();
        }
        catch (RepositoryException exc) {
            return Response.status((int)409).build();
        }
        return Response.status((int)201).build();
    }

    private void createVersion(Node fileNode, InputStream inputStream, String mimeType, List<String> mixins) throws RepositoryException {
        if (!fileNode.isNodeType("mix:versionable")) {
            if (fileNode.canAddMixin("mix:versionable")) {
                fileNode.addMixin("mix:versionable");
                fileNode.getSession().save();
            }
            fileNode.checkin();
            fileNode.getSession().save();
        }
        if (!fileNode.isCheckedOut()) {
            fileNode.checkout();
            fileNode.getSession().save();
        }
        this.updateContent(fileNode, inputStream, mimeType, mixins);
        fileNode.getSession().save();
        fileNode.checkin();
        fileNode.getSession().save();
    }

    private void updateContent(Node node, InputStream inputStream, String mimeType, List<String> mixins) throws RepositoryException {
        Node content = node.getNode("jcr:content");
        content.setProperty("jcr:mimeType", mimeType);
        content.setProperty("jcr:lastModified", Calendar.getInstance());
        content.setProperty("jcr:data", inputStream);
        for (String mixinName : mixins) {
            if (!content.canAddMixin(mixinName)) continue;
            content.addMixin(mixinName);
        }
    }
}

