/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.ResourceBinder;
import org.exoplatform.services.rest.container.ResourceDescriptor;
import org.exoplatform.services.webdav.WebDavService;
import org.exoplatform.services.webdav.common.representation.property.ChildCountRepresentation;
import org.exoplatform.services.webdav.common.representation.property.CreationDateRepresentation;
import org.exoplatform.services.webdav.common.representation.property.CreatorDisplayNameRepresentation;
import org.exoplatform.services.webdav.common.representation.property.DisplayNameRepresentation;
import org.exoplatform.services.webdav.common.representation.property.GetContentLengthRepresentation;
import org.exoplatform.services.webdav.common.representation.property.GetContentTypeRepresentation;
import org.exoplatform.services.webdav.common.representation.property.GetLastModifiedRepresentation;
import org.exoplatform.services.webdav.common.representation.property.HasChildrenRepresentation;
import org.exoplatform.services.webdav.common.representation.property.IsCollectionRepresentation;
import org.exoplatform.services.webdav.common.representation.property.IsFolderRepresentation;
import org.exoplatform.services.webdav.common.representation.property.IsRootRepresentation;
import org.exoplatform.services.webdav.common.representation.property.JcrPropertyRepresentation;
import org.exoplatform.services.webdav.common.representation.property.ParentNameRepresentation;
import org.exoplatform.services.webdav.common.representation.property.PropertyRepresentation;
import org.exoplatform.services.webdav.common.representation.property.ResourceTypeRepresentation;
import org.exoplatform.services.webdav.common.representation.property.SupportedMethodSetRepresentation;
import org.exoplatform.services.webdav.config.WebDavConfig;
import org.exoplatform.services.webdav.config.WebDavConfigImpl;
import org.exoplatform.services.webdav.deltav.representation.property.CheckedInRepresentation;
import org.exoplatform.services.webdav.deltav.representation.property.CheckedOutRepresentation;
import org.exoplatform.services.webdav.deltav.representation.property.IsVersionedRepresentation;
import org.exoplatform.services.webdav.deltav.representation.property.LabelNameSetRepresentation;
import org.exoplatform.services.webdav.deltav.representation.property.PredecessorSetRepresentation;
import org.exoplatform.services.webdav.deltav.representation.property.SuccessorSetRepresentation;
import org.exoplatform.services.webdav.deltav.representation.property.VersionHistoryRepresentation;
import org.exoplatform.services.webdav.deltav.representation.property.VersionNameRepresentation;
import org.exoplatform.services.webdav.lock.FakeLockTable;
import org.exoplatform.services.webdav.lock.representation.property.LockDiscoveryRepresentation;
import org.exoplatform.services.webdav.lock.representation.property.SupportedLockRepresentation;
import org.exoplatform.services.webdav.order.representation.property.OrderingTypeRepresentation;
import org.exoplatform.services.webdav.search.representation.property.SupportedQueryGrammarSetRepresentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDavServiceImpl
implements WebDavService {
    private static Log log = ExoLogger.getLogger((String)"jcr.WebDavServiceImpl");
    public static final String WEBDAVCONFIG_PATH = "/conf/exo-webdav-config.xml";
    protected RepositoryService repositoryService;
    protected ResourceBinder resourceBinder;
    protected WebDavConfig config;
    protected FakeLockTable lockTable;
    private HashMap<String, HashMap<String, String>> properties = new HashMap();
    private HashMap<String, String> ownerTable = new HashMap();

    public WebDavServiceImpl(InitParams params, RepositoryService repositoryService, ResourceBinder resourceBinder) throws Exception {
        this.repositoryService = repositoryService;
        this.resourceBinder = resourceBinder;
        this.config = new WebDavConfigImpl(params, WEBDAVCONFIG_PATH);
        this.lockTable = new FakeLockTable();
        this.registerProperty("DAV:", "childcount", ChildCountRepresentation.class.getCanonicalName());
        this.registerProperty("DAV:", "getcontentlength", GetContentLengthRepresentation.class.getCanonicalName());
        this.registerProperty("DAV:", "getcontenttype", GetContentTypeRepresentation.class.getCanonicalName());
        this.registerProperty("DAV:", "creationdate", CreationDateRepresentation.class.getCanonicalName());
        this.registerProperty("DAV:", "creator-displayname", CreatorDisplayNameRepresentation.class.getCanonicalName());
        this.registerProperty("DAV:", "displayname", DisplayNameRepresentation.class.getCanonicalName());
        this.registerProperty("DAV:", "haschildren", HasChildrenRepresentation.class.getCanonicalName());
        this.registerProperty("DAV:", "iscollection", IsCollectionRepresentation.class.getCanonicalName());
        this.registerProperty("DAV:", "isfolder", IsFolderRepresentation.class.getCanonicalName());
        this.registerProperty("DAV:", "isroot", IsRootRepresentation.class.getCanonicalName());
        this.registerProperty("DAV:", "getlastmodified", GetLastModifiedRepresentation.class.getCanonicalName());
        this.registerProperty("DAV:", "parentname", ParentNameRepresentation.class.getCanonicalName());
        this.registerProperty("DAV:", "resourcetype", ResourceTypeRepresentation.class.getCanonicalName());
        this.registerProperty("DAV:", "supported-method-set", SupportedMethodSetRepresentation.class.getCanonicalName());
        this.registerProperty("DAV:", "checked-in", CheckedInRepresentation.class.getCanonicalName());
        this.registerProperty("DAV:", "checked-out", CheckedOutRepresentation.class.getCanonicalName());
        this.registerProperty("DAV:", "isversioned", IsVersionedRepresentation.class.getCanonicalName());
        this.registerProperty("DAV:", "predecessor-set", PredecessorSetRepresentation.class.getCanonicalName());
        this.registerProperty("DAV:", "successor-set", SuccessorSetRepresentation.class.getCanonicalName());
        this.registerProperty("DAV:", "version-history", VersionHistoryRepresentation.class.getCanonicalName());
        this.registerProperty("DAV:", "version-name", VersionNameRepresentation.class.getCanonicalName());
        this.registerProperty("DAV:", "label-name-set", LabelNameSetRepresentation.class.getCanonicalName());
        this.registerProperty("DAV:", "supportedlock", SupportedLockRepresentation.class.getCanonicalName());
        this.registerProperty("DAV:", "lockdiscovery", LockDiscoveryRepresentation.class.getCanonicalName());
        this.registerProperty("DAV:", "ordering-type", OrderingTypeRepresentation.class.getCanonicalName());
        this.registerProperty("DAV:", "supported-query-grammar-set", SupportedQueryGrammarSetRepresentation.class.getCanonicalName());
    }

    @Override
    public WebDavConfig getConfig() {
        return this.config;
    }

    @Override
    public HashMap<String, String> getOwnerTable() {
        return this.ownerTable;
    }

    @Override
    public ArrayList<String> getAvailableCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        List descriptors = this.resourceBinder.getAllDescriptors();
        for (int i = 0; i < descriptors.size(); ++i) {
            ResourceDescriptor descriptor = (ResourceDescriptor)descriptors.get(i);
            String acceptableMethod = descriptor.getAcceptableMethod();
            String uriPattern = descriptor.getURIPattern().getString();
            if (!uriPattern.startsWith("/jcr/")) continue;
            commands.add(acceptableMethod);
        }
        return commands;
    }

    @Override
    public ManageableRepository getRepository(String repositoryName) throws RepositoryException {
        try {
            return this.repositoryService.getRepository(repositoryName);
        }
        catch (RepositoryConfigurationException exc) {
            log.info((Object)"Repository configuration error!");
            throw new RepositoryException(exc.getMessage());
        }
    }

    @Override
    public FakeLockTable getLockTable() {
        return this.lockTable;
    }

    @Override
    public PropertyRepresentation getPropertyRepresentation(String nameSpaceURI, String propertyName, String href) {
        HashMap<String, String> nameSpacedMap = this.properties.get(nameSpaceURI);
        if (nameSpacedMap == null) {
            return new JcrPropertyRepresentation(nameSpaceURI, propertyName);
        }
        String className = nameSpacedMap.get(propertyName);
        if (className == null) {
            return new JcrPropertyRepresentation(nameSpaceURI, propertyName);
        }
        try {
            Class<?> propertyClass = Class.forName(className);
            try {
                Constructor<?> constructor = propertyClass.getConstructor(WebDavService.class);
                return (PropertyRepresentation)constructor.newInstance(this);
            }
            catch (NoSuchMethodException mexc) {
                try {
                    Constructor<?> constructor = propertyClass.getConstructor(String.class);
                    return (PropertyRepresentation)constructor.newInstance(href);
                }
                catch (NoSuchMethodException mexc2) {
                    return (PropertyRepresentation)propertyClass.newInstance();
                }
            }
        }
        catch (Exception exc) {
            return new JcrPropertyRepresentation(nameSpaceURI, propertyName);
        }
    }

    @Override
    public void registerProperty(String nameSpace, String name, String className) {
        HashMap<String, String> nameSpacedList = this.properties.get(nameSpace);
        if (nameSpacedList == null) {
            nameSpacedList = new HashMap();
            this.properties.put(nameSpace, nameSpacedList);
        }
        if (nameSpacedList.get(name) == null) {
            nameSpacedList.put(name, className);
        }
    }

    @Override
    public HashMap<String, HashMap<String, String>> getProperies() {
        return this.properties;
    }
}

