/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.exoplatform.services.rest.transformer.InputEntityTransformer;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class WebDavXmlInputTransformer
extends InputEntityTransformer {
    public WebDavXmlInputTransformer() {
        super(new Object[0]);
    }

    public Document readFrom(InputStream entityDataStream) throws IOException {
        try {
            int readed;
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[2048];
            while ((readed = entityDataStream.read(buffer)) >= 0) {
                outStream.write(buffer, 0, readed);
            }
            byte[] bytes = outStream.toByteArray();
            if (bytes.length == 0) {
                return null;
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            return factory.newDocumentBuilder().parse(new ByteArrayInputStream(bytes));
        }
        catch (SAXException saxe) {
            return null;
        }
        catch (ParserConfigurationException pce) {
            throw new IOException("Can't read from input stream " + pce);
        }
    }
}

