/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.common.command;

import java.util.Calendar;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.HeaderParam;
import org.exoplatform.services.rest.InputTransformer;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.ResourceDispatcher;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.transformer.PassthroughInputTransformer;
import org.exoplatform.services.rest.transformer.PassthroughOutputTransformer;
import org.exoplatform.services.webdav.WebDavService;
import org.exoplatform.services.webdav.common.command.WebDavCommand;
import org.exoplatform.services.webdav.common.resource.JCRResourceDispatcher;
import org.exoplatform.services.webdav.common.resource.resourcedata.AbstractResourceData;
import org.exoplatform.services.webdav.common.resource.resourcedata.JcrFileResourceData;
import org.exoplatform.services.webdav.common.resource.resourcedata.JcrPropertyData;
import org.exoplatform.services.webdav.common.resource.resourcedata.XmlItemData;

@URITemplate(value="/jcr/")
public class HeadCommand
extends WebDavCommand {
    public HeadCommand(WebDavService webDavService, ResourceDispatcher resourceDispatcher, ThreadLocalSessionProviderService sessionProviderService) {
        super(webDavService, resourceDispatcher, sessionProviderService);
    }

    @HTTPMethod(value="HEAD")
    @URITemplate(value="/{repoName}/")
    @InputTransformer(value=PassthroughInputTransformer.class)
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response head() {
        return Response.Builder.ok().header("Last-Modified", "" + Calendar.getInstance()).header("Content-type", "text/html").build();
    }

    @HTTPMethod(value="HEAD")
    @URITemplate(value="/{repoName}/{repoPath}/")
    @InputTransformer(value=PassthroughInputTransformer.class)
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response head(@URIParam(value="repoName") String repoName, @URIParam(value="repoPath") String repoPath, @HeaderParam(value="Authorization") String authorization) {
        return this.doHead(repoName, repoPath, authorization);
    }

    private Response doHead(String repoName, String repoPath, String authorization) {
        try {
            String href = this.getHref(repoPath);
            SessionProvider sessionProvider = this.getSessionProvider(authorization);
            Item item = new JCRResourceDispatcher(sessionProvider, this.webDavService.getRepository(repoName)).getItem(repoPath);
            AbstractResourceData resourceData = null;
            boolean isCollection = false;
            if (item instanceof Node) {
                Node node = (Node)item;
                if (node.isNodeType("nt:file")) {
                    resourceData = new JcrFileResourceData(node);
                } else {
                    resourceData = new XmlItemData(href + node.getPath(), node);
                    isCollection = true;
                }
            } else {
                resourceData = new JcrPropertyData((Property)item);
            }
            if (isCollection) {
                return Response.Builder.ok().header("Last-Modified", resourceData.getLastModified()).header("Content-type", resourceData.getContentType()).build();
            }
            return Response.Builder.ok().header("Last-Modified", resourceData.getLastModified()).header("Content-type", resourceData.getContentType()).header("Content-Length", "" + resourceData.getContentLength()).build();
        }
        catch (Exception exc) {
            return this.responseByException(exc);
        }
    }
}

