/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.common.command;

import java.util.ArrayList;
import javax.jcr.AccessDeniedException;
import javax.jcr.Session;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.HeaderParam;
import org.exoplatform.services.rest.InputTransformer;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.ResourceDispatcher;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.transformer.PassthroughInputTransformer;
import org.exoplatform.services.rest.transformer.PassthroughOutputTransformer;
import org.exoplatform.services.webdav.WebDavService;
import org.exoplatform.services.webdav.common.command.WebDavCommand;
import org.exoplatform.services.webdav.common.util.DavTextUtil;

@URITemplate(value="/jcr/")
public class MoveCommand
extends WebDavCommand {
    public MoveCommand(WebDavService webDavService, ResourceDispatcher resourceDispatcher, ThreadLocalSessionProviderService sessionProviderService) {
        super(webDavService, resourceDispatcher, sessionProviderService);
    }

    @HTTPMethod(value="MOVE")
    @URITemplate(value="/{repoName}/{repoPath}/")
    @InputTransformer(value=PassthroughInputTransformer.class)
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response move(@URIParam(value="repoName") String repoName, @URIParam(value="repoPath") String repoPath, @HeaderParam(value="Authorization") String authorization, @HeaderParam(value="Destination") String destinationHeader, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader) {
        try {
            String prefix = this.getPrefix(repoPath);
            destinationHeader = DavTextUtil.UnEscape(destinationHeader, '%');
            if (!destinationHeader.startsWith(prefix)) {
                throw new AccessDeniedException();
            }
            String destination = destinationHeader.substring((prefix + "/").length());
            if (repoPath.split("/").length < 2) {
                throw new AccessDeniedException();
            }
            if (destination.split("/").length < 2) {
                throw new AccessDeniedException();
            }
            String srcWorkspace = repoPath.split("/")[0];
            String destWorkspace = destination.split("/")[0];
            String srcPath = repoPath.substring(srcWorkspace.length());
            String destPath = destination.substring(destWorkspace.length());
            ArrayList<String> lockTokens = this.getLockTokens(lockTokenHeader, ifHeader);
            SessionProvider sessionProvider = this.getSessionProvider(authorization);
            ManageableRepository repository = this.webDavService.getRepository(repoName);
            if (srcWorkspace.equals(destWorkspace)) {
                Session session = sessionProvider.getSession(srcWorkspace, repository);
                this.tuneSession(session, lockTokens);
                session.move(srcPath, destPath);
                session.save();
            } else {
                Session srcSession = sessionProvider.getSession(srcWorkspace, repository);
                Session destSession = sessionProvider.getSession(destWorkspace, repository);
                this.tuneSession(srcSession, lockTokens);
                this.tuneSession(destSession, lockTokens);
                destSession.getWorkspace().copy(srcWorkspace, srcPath, destPath);
                srcSession.getItem(srcPath).remove();
                srcSession.save();
            }
            sessionProvider.close();
            return Response.Builder.withStatus((int)201).build();
        }
        catch (Exception exc) {
            return this.responseByException(exc);
        }
    }
}

