/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.common.command;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.HeaderParam;
import org.exoplatform.services.rest.InputTransformer;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.ResourceDispatcher;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.transformer.PassthroughInputTransformer;
import org.exoplatform.services.rest.transformer.PassthroughOutputTransformer;
import org.exoplatform.services.webdav.WebDavService;
import org.exoplatform.services.webdav.common.command.NodeTypedCommand;
import org.exoplatform.services.webdav.lock.FakeLockTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@URITemplate(value="/jcr/")
public class PutCommand
extends NodeTypedCommand {
    public PutCommand(WebDavService webDavService, ResourceDispatcher resourceDispatcher, ThreadLocalSessionProviderService sessionProviderService) {
        super(webDavService, resourceDispatcher, sessionProviderService);
    }

    @HTTPMethod(value="PUT")
    @URITemplate(value="/{repoName}/{repoPath}/")
    @InputTransformer(value=PassthroughInputTransformer.class)
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response put(@URIParam(value="repoName") String repoName, @URIParam(value="repoPath") String repoPath, InputStream inputStream, @HeaderParam(value="Authorization") String authorization, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader, @HeaderParam(value="NodeType") String nodeTypeHeader, @HeaderParam(value="MixType") String mixinTypesHeader, @HeaderParam(value="Content-type") String mimeType) {
        try {
            if (repoPath.split("/").length < 2) {
                throw new AccessDeniedException();
            }
            String srcWorkspace = repoPath.split("/")[0];
            String srcPath = repoPath.substring(srcWorkspace.length());
            String fileName = this.getFileName(repoPath);
            String fileDirectory = this.getFilePath(repoPath);
            SessionProvider sessionProvider = this.getSessionProvider(authorization);
            ManageableRepository repository = this.webDavService.getRepository(repoName);
            Session session = sessionProvider.getSession(srcWorkspace, repository);
            ArrayList<String> lockTokens = this.getLockTokens(lockTokenHeader, ifHeader);
            this.tuneSession(session, lockTokens);
            String nodeType = this.getNodeType(nodeTypeHeader);
            if (nodeType == null) {
                nodeType = this.webDavService.getConfig().getDefFileNodeType();
            }
            if (mimeType == null) {
                MimeTypeResolver mimeTypeResolver = new MimeTypeResolver();
                mimeTypeResolver.setDefaultMimeType(this.webDavService.getConfig().getDefFileMimeType());
                mimeType = mimeTypeResolver.getMimeType(fileName);
            }
            try {
                Item item = session.getItem(srcPath);
                if (item instanceof Property) {
                    throw new AccessDeniedException();
                }
                String updatePolicyType = this.webDavService.getConfig().getUpdatePolicyType();
                if (updatePolicyType.equals("add")) {
                    this.createNtFile(session, fileDirectory, fileName, inputStream, mimeType, nodeType);
                } else if (updatePolicyType.equals("create-version")) {
                    this.createNtFileVersion((Node)item, mimeType, inputStream);
                } else {
                    this.updateNtFile((Node)item, mimeType, inputStream);
                }
            }
            catch (PathNotFoundException pexc) {
                this.checkLocked(repoName + "/" + repoPath, lockTokens);
                this.createNtFile(session, fileDirectory, fileName, inputStream, mimeType, nodeType);
            }
            sessionProvider.close();
            return Response.Builder.withStatus((int)201).build();
        }
        catch (Exception exc) {
            return this.responseByException(exc);
        }
    }

    private String getFilePath(String repoPath) {
        String curPath = repoPath;
        curPath = curPath.substring(curPath.indexOf("/"));
        if ("".equals(curPath = curPath.substring(0, curPath.lastIndexOf("/")))) {
            curPath = "/";
        }
        return curPath;
    }

    private String getFileName(String repoPath) {
        String[] curNames = repoPath.split("/");
        return curNames[curNames.length - 1];
    }

    private void checkLocked(String sourceHref, ArrayList<String> sessionLockTokens) throws LockException {
        FakeLockTable lockTable = this.webDavService.getLockTable();
        String presentLockToken = lockTable.getLockToken(sourceHref);
        if (presentLockToken != null) {
            boolean tokenFinded = false;
            for (int i = 0; i < sessionLockTokens.size(); ++i) {
                if (!presentLockToken.equals(sessionLockTokens.get(i))) continue;
                tokenFinded = true;
                break;
            }
            if (!tokenFinded) {
                throw new LockException("Resource locked!!!");
            }
        }
    }

    protected void createNtFile(Session session, String folderPath, String fileName, InputStream inputStream, String mimeType, String nodeType) throws Exception {
        String folderNodeType = this.webDavService.getConfig().getDefFolderNodeType();
        String[] pathes = folderPath.split("/");
        Node node = session.getRootNode();
        for (int i = 0; i < pathes.length; ++i) {
            if ("".equals(pathes[i])) continue;
            node = node.hasNode(pathes[i]) ? node.getNode(pathes[i]) : node.addNode(pathes[i], folderNodeType);
        }
        Node ntFileNode = node.addNode(fileName, nodeType);
        Node contentNode = ntFileNode.addNode("jcr:content", "nt:resource");
        this.fillFileContent(contentNode, mimeType, inputStream);
        session.save();
    }

    private void fillFileContent(Node node, String mimeType, InputStream inputStream) throws Exception {
        node.setProperty("jcr:mimeType", mimeType);
        node.setProperty("jcr:lastModified", Calendar.getInstance());
        node.setProperty("jcr:data", inputStream);
    }

    protected void createNtFileVersion(Node fileNode, String mimeType, InputStream inputStream) throws Exception {
        if (!fileNode.isNodeType("mix:versionable")) {
            fileNode.addMixin("mix:versionable");
            fileNode.getSession().save();
            fileNode.checkout();
            fileNode.checkin();
        }
        fileNode.checkout();
        this.updateNtFile(fileNode, mimeType, inputStream);
        fileNode.checkin();
    }

    protected void updateNtFile(Node fileNode, String mimeType, InputStream inputStream) throws Exception {
        Node contentNode = fileNode.getNode("jcr:content");
        this.fillFileContent(contentNode, mimeType, inputStream);
        fileNode.getSession().save();
    }
}

