/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.common.command;

import java.util.ArrayList;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.lock.LockException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.ResourceDispatcher;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.services.webdav.WebDavService;
import org.exoplatform.services.webdav.common.BadRequestException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebDavCommand
implements ResourceContainer {
    private static Log log = ExoLogger.getLogger((String)"jcr.WebDavCommand");
    protected WebDavService webDavService;
    protected ResourceDispatcher resourceDispatcher;
    private ThreadLocalSessionProviderService sessionProviderService;

    public WebDavCommand(WebDavService webDavService, ResourceDispatcher resourceDispatcher, ThreadLocalSessionProviderService sessionProviderService) {
        this.webDavService = webDavService;
        this.resourceDispatcher = resourceDispatcher;
        this.sessionProviderService = sessionProviderService;
    }

    /*
     * Unable to fully structure code
     */
    public SessionProvider getSessionProvider(String authorization) throws LoginException {
        credentials = null;
        decodedAuth = "";
        if (authorization != null) {
            try {
                basic = authorization.split(" ");
                if (basic.length < 2 || !basic[0].equalsIgnoreCase("BASIC")) ** GOTO lbl13
                decodedAuth = new String(Base64.decodeBase64((byte[])basic[1].getBytes()));
            }
            catch (Exception exc) {
                throw new LoginException();
            }
        } else if (this.webDavService.getConfig().getDefIdentity() != null) {
            decodedAuth = this.webDavService.getConfig().getDefIdentity();
        }
lbl13:
        // 5 sources

        authParams = decodedAuth.split(":");
        userId = authParams.length > 0 ? authParams[0] : "";
        userPass = authParams.length > 1 ? authParams[1] : "";
        credentials = new SimpleCredentials(userId, userPass.toCharArray());
        sessionProvider = new SessionProvider((Credentials)credentials);
        return sessionProvider;
    }

    public String getPrefix(String repoPath) {
        String prefix = this.resourceDispatcher.getRuntimeContext().getAbsLocation();
        if (prefix.endsWith("/")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        prefix = prefix.substring(0, prefix.length() - repoPath.length());
        prefix = prefix.substring(0, prefix.length() - 1);
        return prefix;
    }

    public String getHref(String repoPath) {
        String href = this.resourceDispatcher.getRuntimeContext().getAbsLocation();
        if (href.endsWith("/")) {
            href = href.substring(0, href.length() - 1);
        }
        if ((href = href.substring(0, href.length() - repoPath.length()) + repoPath.split("/")[0]).endsWith("/")) {
            href = href.substring(0, href.length() - 1);
        }
        return href;
    }

    protected void tuneSession(Session session, ArrayList<String> lockTokens) {
        String lockToken;
        int i;
        String[] presentLockTokens = session.getLockTokens();
        ArrayList<String> presentLockTokensList = new ArrayList<String>();
        for (i = 0; i < presentLockTokens.length; ++i) {
            lockToken = presentLockTokens[i];
            presentLockTokensList.add(lockToken);
        }
        for (i = 0; i < lockTokens.size(); ++i) {
            lockToken = lockTokens.get(i);
            if (presentLockTokensList.contains(lockToken)) continue;
            session.addLockToken(lockToken);
        }
    }

    protected ArrayList<String> getLockTokens(String lockTokenHeader, String ifHeader) {
        ArrayList<String> lockTokens = new ArrayList<String>();
        if (lockTokenHeader != null) {
            lockTokenHeader = lockTokenHeader.substring(1, lockTokenHeader.length() - 1);
            lockTokens.add(lockTokenHeader);
        }
        if (ifHeader != null) {
            String headerLockToken = ifHeader.substring(ifHeader.indexOf("("));
            headerLockToken = headerLockToken.substring(2, headerLockToken.length() - 2);
            lockTokens.add(headerLockToken);
        }
        return lockTokens;
    }

    public Response responseByException(Exception exception) {
        try {
            throw exception;
        }
        catch (BadRequestException exc) {
            return Response.Builder.badRequest().build();
        }
        catch (PathNotFoundException exc) {
            return Response.Builder.withStatus((int)404).build();
        }
        catch (LoginException exc) {
            String wwwAuthencticate = this.webDavService.getConfig().getAuthHeader();
            return Response.Builder.withStatus((int)401).header("WWW-Authenticate", wwwAuthencticate).build();
        }
        catch (NoSuchWorkspaceException exc) {
            return Response.Builder.withStatus((int)403).build();
        }
        catch (AccessDeniedException exc) {
            return Response.Builder.withStatus((int)403).build();
        }
        catch (LockException exc) {
            return Response.Builder.withStatus((int)403).build();
        }
        catch (Exception exc) {
            log.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
            return Response.Builder.serverError().build();
        }
    }
}

