/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.common.representation.property;

import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.webdav.common.representation.property.WebDavPropertyRepresentation;

public class GetLastModifiedRepresentation
extends WebDavPropertyRepresentation {
    public static final String TAGNAME = "getlastmodified";
    private String lastModified = "";

    public void read(Node node) {
        try {
            Node contentNode = node.getNode("jcr:content");
            Property lastModifiedProp = contentNode.getProperty("jcr:lastModified");
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            this.lastModified = dateFormat.format(lastModifiedProp.getDate().getTime());
            this.status = 200;
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public String getTagName() {
        return TAGNAME;
    }

    protected void writeContent(XMLStreamWriter xmlWriter) throws XMLStreamException {
        xmlWriter.writeAttribute("b:dt", "dateTime.rfc1123");
        xmlWriter.writeCharacters(this.lastModified);
    }
}

