/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.common.representation.read;

import java.util.ArrayList;
import java.util.HashMap;
import javax.jcr.Item;
import javax.jcr.RepositoryException;
import org.exoplatform.services.webdav.WebDavService;
import org.exoplatform.services.webdav.common.representation.read.AllPropResponseRepresentation;
import org.exoplatform.services.webdav.common.representation.read.PropFindResponseRepresentation;
import org.exoplatform.services.webdav.common.representation.read.PropNamesResponseRepresentation;
import org.exoplatform.services.webdav.common.representation.read.PropResponseRepresentation;
import org.exoplatform.services.webdav.common.util.DavUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropFindRepresentationFactory {
    public static final String XML_PROPFIND = "propfind";
    public static final String XML_PROPNAME = "propname";

    public static PropFindResponseRepresentation createResponseRepresentation(WebDavService webDavService, Document document, Item node, String href, int depth) throws RepositoryException {
        if (document == null) {
            return new AllPropResponseRepresentation(webDavService, href, (javax.jcr.Node)node, depth);
        }
        Node propFind = DavUtil.getChildNode(document, XML_PROPFIND);
        if (DavUtil.getChildNode(propFind, "allprop") != null) {
            return new AllPropResponseRepresentation(webDavService, href, (javax.jcr.Node)node, depth);
        }
        if (DavUtil.getChildNode(propFind, XML_PROPNAME) != null) {
            return new PropNamesResponseRepresentation(webDavService, href, (javax.jcr.Node)node, depth);
        }
        Node props = DavUtil.getChildNode(propFind, "prop");
        if (DavUtil.getChildNode(props, "allprop") != null) {
            return new AllPropResponseRepresentation(webDavService, href, (javax.jcr.Node)node, depth);
        }
        HashMap<String, ArrayList<String>> properties = PropFindRepresentationFactory.getProperties(props);
        return new PropResponseRepresentation(webDavService, properties, href, (javax.jcr.Node)node, depth);
    }

    public static HashMap<String, ArrayList<String>> getProperties(Node props) {
        HashMap<String, ArrayList<String>> properties = new HashMap<String, ArrayList<String>>();
        NodeList nodes = props.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node curNode = nodes.item(i);
            String name = curNode.getLocalName();
            String nameSpace = curNode.getNamespaceURI();
            if (name == null) continue;
            ArrayList<String> nameSpacedList = properties.get(nameSpace);
            if (nameSpacedList == null) {
                nameSpacedList = new ArrayList();
                properties.put(nameSpace, nameSpacedList);
            }
            if (nameSpacedList.contains(name)) continue;
            nameSpacedList.add(name);
        }
        return properties;
    }
}

