/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.common.representation.read;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.webdav.WebDavService;
import org.exoplatform.services.webdav.common.representation.HrefRepresentation;
import org.exoplatform.services.webdav.common.representation.WebDavNameSpaceContext;
import org.exoplatform.services.webdav.common.representation.XmlResponseRepresentation;

public abstract class PropFindResponseRepresentation
extends XmlResponseRepresentation {
    public static final String XML_MULTISTATUS = "multistatus";
    public static final String XML_RESPONSE = "response";
    protected String defaultHref;
    protected String href;
    protected Node node;
    protected int depth;
    protected WebDavService webDavService;

    public PropFindResponseRepresentation(WebDavService webDavService, String defaultHref, Node node, int depth) throws RepositoryException {
        super(new WebDavNameSpaceContext((ManageableRepository)node.getSession().getRepository()));
        this.webDavService = webDavService;
        this.defaultHref = defaultHref;
        this.node = node;
        this.depth = depth;
    }

    protected void write(XMLStreamWriter xmlStreamWriter) throws XMLStreamException, RepositoryException {
        xmlStreamWriter.writeStartElement("D", XML_MULTISTATUS, "DAV:");
        xmlStreamWriter.writeNamespace("D", "DAV:");
        xmlStreamWriter.writeAttribute("xmlns:b", "urn:uuid:c2f41010-65b3-11d1-a29f-00aa00c14882/");
        this.listRecursive(xmlStreamWriter, this.node, this.depth);
        xmlStreamWriter.writeEndElement();
    }

    protected void listRecursive(XMLStreamWriter xmlStreamWriter, Node curNode, int curDepth) throws XMLStreamException, RepositoryException {
        xmlStreamWriter.writeStartElement("D", XML_RESPONSE, "DAV:");
        this.href = this.defaultHref + curNode.getPath();
        new HrefRepresentation(this.href).write(xmlStreamWriter);
        this.writeResponseContent(xmlStreamWriter, curNode);
        xmlStreamWriter.writeEndElement();
        if (curDepth == 0 || curNode.isNodeType("nt:file")) {
            return;
        }
        NodeIterator nodeIter = curNode.getNodes();
        while (nodeIter.hasNext()) {
            Node childNode = nodeIter.nextNode();
            this.listRecursive(xmlStreamWriter, childNode, curDepth - 1);
        }
    }

    protected abstract void writeResponseContent(XMLStreamWriter var1, Node var2) throws XMLStreamException, RepositoryException;
}

