/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.common.representation.read;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.webdav.WebDavService;
import org.exoplatform.services.webdav.WebDavStatus;
import org.exoplatform.services.webdav.common.representation.property.PropertyRepresentation;
import org.exoplatform.services.webdav.common.representation.read.PropFindResponseRepresentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropResponseRepresentation
extends PropFindResponseRepresentation {
    private HashMap<String, ArrayList<String>> properties;

    public PropResponseRepresentation(WebDavService webDavService, HashMap<String, ArrayList<String>> properties, String href, Node node, int depth) throws RepositoryException {
        super(webDavService, href, node, depth);
        this.properties = properties;
    }

    @Override
    protected void writeResponseContent(XMLStreamWriter xmlStreamWriter, Node node) throws XMLStreamException, RepositoryException {
        ArrayList<PropertyRepresentation> propertyRepresentations = new ArrayList<PropertyRepresentation>();
        Set<String> nameSpaces = this.properties.keySet();
        for (String propertyNameSpace : nameSpaces) {
            ArrayList<String> propertyList = this.properties.get(propertyNameSpace);
            for (int i = 0; i < propertyList.size(); ++i) {
                String propertyName = propertyList.get(i);
                PropertyRepresentation representation = this.webDavService.getPropertyRepresentation(propertyNameSpace, propertyName, this.href);
                propertyRepresentations.add(representation);
                representation.read(node);
            }
        }
        HashMap<Integer, ArrayList<PropertyRepresentation>> propStatusGroup = new HashMap<Integer, ArrayList<PropertyRepresentation>>();
        for (int i = 0; i < propertyRepresentations.size(); ++i) {
            PropertyRepresentation representation = (PropertyRepresentation)propertyRepresentations.get(i);
            ArrayList<PropertyRepresentation> statusList = (ArrayList<PropertyRepresentation>)propStatusGroup.get(representation.getStatus());
            if (statusList == null) {
                statusList = new ArrayList<PropertyRepresentation>();
                propStatusGroup.put(representation.getStatus(), statusList);
            }
            statusList.add(representation);
        }
        Iterator statusIterator = propStatusGroup.keySet().iterator();
        while (statusIterator.hasNext()) {
            int curStatus = (Integer)statusIterator.next();
            xmlStreamWriter.writeStartElement("DAV:", "propstat");
            xmlStreamWriter.writeStartElement("DAV:", "prop");
            ArrayList representationList = (ArrayList)propStatusGroup.get(curStatus);
            for (int i = 0; i < representationList.size(); ++i) {
                PropertyRepresentation representation = (PropertyRepresentation)representationList.get(i);
                representation.write(xmlStreamWriter);
            }
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeStartElement("DAV:", "status");
            xmlStreamWriter.writeCharacters(WebDavStatus.getStatusDescription(curStatus));
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndElement();
        }
    }
}

