/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.common.representation.write;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.webdav.WebDavStatus;
import org.exoplatform.services.webdav.common.representation.HrefRepresentation;
import org.exoplatform.services.webdav.common.representation.WebDavNameSpaceContext;
import org.exoplatform.services.webdav.common.representation.XmlResponseRepresentation;
import org.exoplatform.services.webdav.common.representation.property.PropertyRepresentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyUpdateResponseRepresentation
extends XmlResponseRepresentation {
    public static final String XML_MULTISTATUS = "multistatus";
    public static final String XML_RESPONSE = "response";
    private Node node;
    private String href;
    private ArrayList<PropertyRepresentation> setList;
    private ArrayList<PropertyRepresentation> removeList;

    public PropertyUpdateResponseRepresentation(Item node, String href, ArrayList<PropertyRepresentation> setList, ArrayList<PropertyRepresentation> removeList) throws RepositoryException {
        super(new WebDavNameSpaceContext((ManageableRepository)node.getSession().getRepository()));
        this.node = (Node)node;
        this.href = href;
        this.setList = setList;
        this.removeList = removeList;
    }

    @Override
    protected void write(XMLStreamWriter writer) throws XMLStreamException, RepositoryException {
        PropertyRepresentation property;
        int i;
        writer.writeStartElement("D", XML_MULTISTATUS, "DAV:");
        writer.writeNamespace("D", "DAV:");
        writer.writeStartElement("D", XML_RESPONSE, "DAV:");
        String responseHref = this.href + this.node.getPath();
        new HrefRepresentation(responseHref).write(writer);
        ArrayList<PropertyRepresentation> properties = new ArrayList<PropertyRepresentation>();
        for (i = 0; i < this.setList.size(); ++i) {
            property = this.setList.get(i);
            property.update(this.node);
            properties.add(property);
        }
        for (i = 0; i < this.removeList.size(); ++i) {
            property = this.removeList.get(i);
            property.remove(this.node);
            properties.add(property);
        }
        HashMap<Integer, ArrayList<PropertyRepresentation>> propStatusGroup = new HashMap<Integer, ArrayList<PropertyRepresentation>>();
        for (int i2 = 0; i2 < properties.size(); ++i2) {
            PropertyRepresentation representation = (PropertyRepresentation)properties.get(i2);
            ArrayList<PropertyRepresentation> statusList = (ArrayList<PropertyRepresentation>)propStatusGroup.get(representation.getStatus());
            if (statusList == null) {
                statusList = new ArrayList<PropertyRepresentation>();
                propStatusGroup.put(representation.getStatus(), statusList);
            }
            statusList.add(representation);
        }
        Iterator statusIterator = propStatusGroup.keySet().iterator();
        while (statusIterator.hasNext()) {
            int curStatus = (Integer)statusIterator.next();
            writer.writeStartElement("DAV:", "propstat");
            writer.writeStartElement("DAV:", "prop");
            ArrayList representationList = (ArrayList)propStatusGroup.get(curStatus);
            for (int i3 = 0; i3 < representationList.size(); ++i3) {
                PropertyRepresentation representation = (PropertyRepresentation)representationList.get(i3);
                representation.write(writer);
            }
            writer.writeEndElement();
            writer.writeStartElement("DAV:", "status");
            writer.writeCharacters(WebDavStatus.getStatusDescription(curStatus));
            writer.writeEndElement();
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

