/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.common.resource;

import javax.jcr.Item;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;

public class JCRResourceDispatcher {
    private SessionProvider sessionProvider;
    private ManageableRepository repository;

    public JCRResourceDispatcher(SessionProvider sessionProvider, ManageableRepository repository) {
        this.sessionProvider = sessionProvider;
        this.repository = repository;
    }

    public Item getItem(String jcrPath) throws RepositoryException {
        String[] pathes = jcrPath.split("/");
        String workspaceName = pathes[0];
        Session session = this.sessionProvider.getSession(workspaceName, this.repository);
        if (pathes.length == 1) {
            return session.getRootNode();
        }
        String path = jcrPath.substring(("/" + pathes[0]).length());
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return session.getItem(path);
    }
}

