/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import javax.jcr.Session;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DavUtil {
    private static Log log = ExoLogger.getLogger((String)"jcr.DavUtil");

    public static Node getChildNode(Node node, String childName) {
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node curNode = nodes.item(i);
            if (curNode.getLocalName() == null || !curNode.getLocalName().equals(childName)) continue;
            return curNode;
        }
        return null;
    }

    public static Document GetDocumentFromInputStream(InputStream in) throws Exception {
        int readed;
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        byte[] buff = new byte[2048];
        while ((readed = in.read(buff)) >= 0) {
            outStream.write(buff, 0, readed);
        }
        byte[] datas = outStream.toByteArray();
        ByteArrayInputStream inStream = new ByteArrayInputStream(datas);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(inStream);
        return document;
    }

    public static Document GetDocumentFromRequest(HttpServletRequest request) throws Exception {
        Document document = null;
        String contentLength = request.getHeader("Content-Length");
        if (contentLength != null && !contentLength.equals("0")) {
            int readed;
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            ServletInputStream inS = request.getInputStream();
            byte[] buffer = new byte[1024];
            while ((readed = inS.read(buffer)) >= 0) {
                outStream.write(buffer, 0, readed);
            }
            String inXML = new String(outStream.toByteArray());
            log.info((Object)"- XML ------------------------------------");
            log.info((Object)inXML);
            log.info((Object)"------------------------------------------");
            ByteArrayInputStream ins2 = new ByteArrayInputStream(outStream.toByteArray());
            document = DavUtil.GetDocumentFromInputStream(ins2);
        }
        return document;
    }

    public static Document getDomDocument() throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.newDocument();
    }

    public static byte[] getSerializedDom(Element element) throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(element.getOwnerDocument());
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        StreamResult resultStream = new StreamResult(outStream);
        transformer.transform(source, resultStream);
        return outStream.toByteArray();
    }

    public static void tuneSession(Session session, ArrayList<String> lockTokens) {
        int i;
        String[] sessionTokens = session.getLockTokens();
        ArrayList<String> sessionTokensList = new ArrayList<String>();
        for (i = 0; i < sessionTokens.length; ++i) {
            sessionTokensList.add(sessionTokens[i]);
        }
        for (i = 0; i < lockTokens.size(); ++i) {
            String token = lockTokens.get(i);
            if (sessionTokensList.contains(token)) continue;
            session.addLockToken(token);
        }
    }
}

