/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.deltav.representation.property;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.webdav.common.representation.HrefRepresentation;
import org.exoplatform.services.webdav.common.representation.property.WebDavPropertyRepresentation;

public class CheckedInRepresentation
extends WebDavPropertyRepresentation {
    public static final String TAGNAME = "checked-in";
    private String href;
    private HrefRepresentation hrefRepresentation;

    public CheckedInRepresentation(String href) {
        this.href = href;
    }

    public void read(Node node) {
        try {
            String hrefValue;
            if (node instanceof Version) {
                hrefValue = this.href + "?VERSIONID=" + node.getName();
            } else {
                if (node.isCheckedOut()) {
                    return;
                }
                hrefValue = this.href + "?VERSIONID=" + node.getBaseVersion().getName();
            }
            this.status = 200;
            this.hrefRepresentation = new HrefRepresentation(hrefValue);
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public String getTagName() {
        return TAGNAME;
    }

    protected void writeContent(XMLStreamWriter xmlWriter) throws XMLStreamException {
        this.hrefRepresentation.write(xmlWriter);
    }
}

