/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.deltav.representation.property;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.webdav.common.representation.property.WebDavPropertyRepresentation;

public class VersionNameRepresentation
extends WebDavPropertyRepresentation {
    public static final String TAGNAME = "version-name";
    private String versionName = "";

    public void read(Node node) {
        try {
            if (node instanceof Version) {
                this.versionName = node.getName();
                this.status = 200;
                return;
            }
            if (node.isNodeType("mix:versionable")) {
                Version baseVersion = node.getBaseVersion();
                this.versionName = baseVersion.getName();
                this.status = 200;
                return;
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public String getTagName() {
        return TAGNAME;
    }

    protected void writeContent(XMLStreamWriter xmlWriter) throws XMLStreamException {
        xmlWriter.writeCharacters(this.versionName);
    }
}

