/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.deltav.representation.versiontree;

import java.util.ArrayList;
import java.util.HashMap;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.webdav.WebDavService;
import org.exoplatform.services.webdav.common.representation.HrefRepresentation;
import org.exoplatform.services.webdav.common.representation.read.PropResponseRepresentation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionTreeResponseRepresentation
extends PropResponseRepresentation {
    public VersionTreeResponseRepresentation(WebDavService webDavService, HashMap<String, ArrayList<String>> properties, String href, Node node) throws RepositoryException {
        super(webDavService, properties, href, node, 0);
    }

    @Override
    protected void listRecursive(XMLStreamWriter xmlStreamWriter, Node curNode, int curDepth) throws XMLStreamException, RepositoryException {
        this.href = this.defaultHref + curNode.getPath();
        VersionHistory versionHistory = curNode.getVersionHistory();
        VersionIterator versionIterator = versionHistory.getAllVersions();
        while (versionIterator.hasNext()) {
            Version version = versionIterator.nextVersion();
            if ("jcr:rootVersion".equals(version.getName())) continue;
            xmlStreamWriter.writeStartElement("D", "response", "DAV:");
            String responseHref = this.href + "?VERSIONID=" + version.getName();
            new HrefRepresentation(responseHref).write(xmlStreamWriter);
            this.writeResponseContent(xmlStreamWriter, (Node)version);
            xmlStreamWriter.writeEndElement();
        }
    }
}

