/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.lock.command;

import java.util.ArrayList;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.lock.Lock;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.HeaderParam;
import org.exoplatform.services.rest.InputTransformer;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.ResourceDispatcher;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.transformer.SerializableTransformer;
import org.exoplatform.services.webdav.WebDavService;
import org.exoplatform.services.webdav.WebDavXmlInputTransformer;
import org.exoplatform.services.webdav.common.command.WebDavCommand;
import org.exoplatform.services.webdav.common.representation.PropertyResponseRepresentation;
import org.exoplatform.services.webdav.common.resource.JCRResourceDispatcher;
import org.exoplatform.services.webdav.lock.FakeLockTable;
import org.exoplatform.services.webdav.lock.representation.LockInfoRepresentation;
import org.exoplatform.services.webdav.lock.representation.property.LockDiscoveryRepresentation;
import org.w3c.dom.Document;

@URITemplate(value="/jcr/")
public class LockCommand
extends WebDavCommand {
    public LockCommand(WebDavService webDavService, ResourceDispatcher resourceDispatcher, ThreadLocalSessionProviderService sessionProviderService) {
        super(webDavService, resourceDispatcher, sessionProviderService);
    }

    @HTTPMethod(value="LOCK")
    @URITemplate(value="/{repoName}/{repoPath}/")
    @InputTransformer(value=WebDavXmlInputTransformer.class)
    @OutputTransformer(value=SerializableTransformer.class)
    public Response getProperties(@URIParam(value="repoName") String repoName, @URIParam(value="repoPath") String repoPath, Document document, @HeaderParam(value="Authorization") String authorization, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader) {
        try {
            SessionProvider sessionProvider = this.getSessionProvider(authorization);
            ManageableRepository repository = this.webDavService.getRepository(repoName);
            LockInfoRepresentation lockInfo = new LockInfoRepresentation(document);
            try {
                Item item = new JCRResourceDispatcher(sessionProvider, repository).getItem(repoPath);
                if ("/".equals(item.getPath())) {
                    throw new AccessDeniedException();
                }
                ArrayList<String> lockTokens = this.getLockTokens(lockTokenHeader, ifHeader);
                this.tuneSession(item.getSession(), lockTokens);
                if (!(item instanceof Node)) {
                    throw new AccessDeniedException();
                }
                Node node = (Node)item;
                if (!node.isNodeType("mix:lockable")) {
                    node.addMixin("mix:lockable");
                    node.getSession().save();
                }
                Lock lockResult = node.lock(true, false);
                node.getSession().save();
                String ownerKey = node.getSession().getWorkspace().getName() + node.getPath();
                this.webDavService.getOwnerTable().put(ownerKey, lockInfo.getLockOwner());
                LockDiscoveryRepresentation lockDiscovery = new LockDiscoveryRepresentation(this.webDavService);
                lockDiscovery.read(node);
                lockDiscovery.setLockToken(lockResult.getLockToken());
                PropertyResponseRepresentation propertyResponseRepresentation = new PropertyResponseRepresentation(repository, lockDiscovery);
                return Response.Builder.withStatus((int)200).header("Lock-Token", "<" + lockDiscovery.getLockToken() + ">").entity((Object)propertyResponseRepresentation, "text/xml").build();
            }
            catch (PathNotFoundException pexc) {
                String ownerKey = repoPath;
                this.webDavService.getOwnerTable().put(ownerKey, lockInfo.getLockOwner());
                FakeLockTable lockTable = this.webDavService.getLockTable();
                String lockToken = lockTable.lockResource(repoName + "/" + repoPath);
                LockDiscoveryRepresentation lockDiscovery = new LockDiscoveryRepresentation(this.webDavService);
                lockDiscovery.setLocked(true);
                lockDiscovery.setLockOwner(lockInfo.getLockOwner());
                lockDiscovery.setLockToken(lockToken);
                lockDiscovery.setStatus(200);
                PropertyResponseRepresentation propertyResponseRepresentation = new PropertyResponseRepresentation(repository, lockDiscovery);
                return Response.Builder.withStatus((int)200).header("Lock-Token", "<" + lockDiscovery.getLockToken() + ">").entity((Object)propertyResponseRepresentation, "text/xml").build();
            }
        }
        catch (Exception exc) {
            return this.responseByException(exc);
        }
    }
}

