/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.lock.command;

import java.util.ArrayList;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.HeaderParam;
import org.exoplatform.services.rest.InputTransformer;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.ResourceDispatcher;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.transformer.PassthroughOutputTransformer;
import org.exoplatform.services.webdav.WebDavService;
import org.exoplatform.services.webdav.WebDavXmlInputTransformer;
import org.exoplatform.services.webdav.common.command.WebDavCommand;
import org.exoplatform.services.webdav.common.resource.JCRResourceDispatcher;
import org.exoplatform.services.webdav.lock.FakeLockTable;
import org.w3c.dom.Document;

@URITemplate(value="/jcr/")
public class UnLockCommand
extends WebDavCommand {
    public UnLockCommand(WebDavService webDavService, ResourceDispatcher resourceDispatcher, ThreadLocalSessionProviderService sessionProviderService) {
        super(webDavService, resourceDispatcher, sessionProviderService);
    }

    @HTTPMethod(value="UNLOCK")
    @URITemplate(value="/{repoName}/{repoPath}/")
    @InputTransformer(value=WebDavXmlInputTransformer.class)
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response getProperties(@URIParam(value="repoName") String repoName, @URIParam(value="repoPath") String repoPath, Document document, @HeaderParam(value="Authorization") String authorization, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader) {
        try {
            ArrayList<String> lockTokens = this.getLockTokens(lockTokenHeader, ifHeader);
            SessionProvider sessionProvider = this.getSessionProvider(authorization);
            Item item = new JCRResourceDispatcher(sessionProvider, this.webDavService.getRepository(repoName)).getItem(repoPath);
            FakeLockTable lockTable = this.webDavService.getLockTable();
            String presentLockToken = lockTable.getLockToken(repoName + "/" + repoPath);
            if (presentLockToken != null) {
                lockTable.unLockResource(repoName + "/" + repoPath);
                return Response.Builder.withStatus((int)204).build();
            }
            if ("/".equals(item.getPath())) {
                throw new AccessDeniedException();
            }
            if (item instanceof Property) {
                throw new AccessDeniedException();
            }
            this.tuneSession(item.getSession(), lockTokens);
            Node node = (Node)item;
            node.unlock();
            node.getSession().save();
            return Response.Builder.withStatus((int)204).build();
        }
        catch (Exception exc) {
            return this.responseByException(exc);
        }
    }
}

