/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.lock.representation;

import org.exoplatform.services.webdav.common.util.DavUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class LockInfoRepresentation {
    public static final String TAGNAME = "lockinfo";
    public static final String LOCKSCOPE_SHARED = "shared";
    public static final String LOCKSCOPE_EXCLUSIVE = "exclusive";
    public static final String LOCKTYPE_WRITE = "write";
    private String lockType = "write";
    private String lockScope = "exclusive";
    private String lockOwner = "";
    private String lockOwnerHref = "";

    public LockInfoRepresentation(Document document) {
        if (document == null) {
            return;
        }
        try {
            Node nOwner;
            Node nScope;
            Node nWrite;
            Node nLockInfo = DavUtil.getChildNode(document, this.getDocumentName());
            Node nLockType = DavUtil.getChildNode(nLockInfo, "locktype");
            if (nLockType != null && (nWrite = DavUtil.getChildNode(nLockType, LOCKTYPE_WRITE)) != null) {
                this.lockType = LOCKTYPE_WRITE;
            }
            if ((nScope = DavUtil.getChildNode(nLockInfo, "lockscope")) != null) {
                Node nShared;
                Node nExclusive = DavUtil.getChildNode(nScope, LOCKSCOPE_EXCLUSIVE);
                if (nExclusive != null) {
                    this.lockScope = LOCKSCOPE_EXCLUSIVE;
                }
                if ((nShared = DavUtil.getChildNode(nScope, LOCKSCOPE_SHARED)) != null) {
                    this.lockScope = LOCKSCOPE_SHARED;
                }
            }
            if ((nOwner = DavUtil.getChildNode(nLockInfo, "owner")) != null) {
                this.lockOwner = nOwner.getTextContent();
                Node nOwnerHref = DavUtil.getChildNode(nOwner, "href");
                if (nOwnerHref != null) {
                    this.lockOwnerHref = nOwnerHref.getTextContent();
                }
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public String getDocumentName() {
        return TAGNAME;
    }

    public String getLockType() {
        return this.lockType;
    }

    public String getLockScope() {
        return this.lockScope;
    }

    public String getLockOwner() {
        return this.lockOwner;
    }

    public void setLockOwner(String lockOwner) {
        this.lockOwner = lockOwner;
    }

    public String getLockOwherHref() {
        return this.lockOwnerHref;
    }
}

