/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.lock.representation.property;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.lock.Lock;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.jcr.core.lock.ExtendedLock;
import org.exoplatform.services.webdav.WebDavService;
import org.exoplatform.services.webdav.common.representation.HrefRepresentation;
import org.exoplatform.services.webdav.common.representation.property.WebDavPropertyRepresentation;

public class LockDiscoveryRepresentation
extends WebDavPropertyRepresentation {
    public static final String TAGNAME = "lockdiscovery";
    public static final String XML_ACTIVELOCK = "activelock";
    public static final String XML_LOCKTYPE = "locktype";
    public static final String XML_WRITE = "write";
    public static final String XML_LOCKSCOPE = "lockscope";
    public static final String XML_EXCLUSIVE = "exclusive";
    public static final String XML_DEPTH = "depth";
    public static final String XML_OWNER = "owner";
    public static final String XML_TIMEOUT = "timeout";
    public static final String XML_LOCKTOKEN = "locktoken";
    private boolean locked = false;
    private String owner = "";
    private long timeOut;
    private String lockToken = "";
    private WebDavService webDavService;

    public LockDiscoveryRepresentation(WebDavService webDavService) {
        this.webDavService = webDavService;
        this.timeOut = 86400L;
    }

    public String getTagName() {
        return TAGNAME;
    }

    public String getLockToken() {
        return this.lockToken;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setLockOwner(String owner) {
        this.owner = owner;
    }

    public void setLockToken(String lockToken) {
        this.lockToken = lockToken;
    }

    public void read(Node node) {
        try {
            if (node.isLocked()) {
                this.locked = true;
                this.owner = this.webDavService.getOwnerTable().get(node.getSession().getWorkspace().getName() + node.getPath());
                Lock lock = node.getLock();
                ExtendedLock lockExt = (ExtendedLock)lock;
                this.timeOut = lockExt.getTimeToDeath();
            }
            this.status = 200;
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    protected void writeContent(XMLStreamWriter xmlWriter) throws XMLStreamException {
        if (!this.locked) {
            return;
        }
        xmlWriter.writeStartElement(this.getNameSpace(), XML_ACTIVELOCK);
        xmlWriter.writeStartElement(this.getNameSpace(), XML_LOCKTYPE);
        xmlWriter.writeStartElement(this.getNameSpace(), XML_WRITE);
        xmlWriter.writeEndElement();
        xmlWriter.writeEndElement();
        xmlWriter.writeStartElement(this.getNameSpace(), XML_LOCKSCOPE);
        xmlWriter.writeStartElement(this.getNameSpace(), XML_EXCLUSIVE);
        xmlWriter.writeEndElement();
        xmlWriter.writeEndElement();
        xmlWriter.writeStartElement(this.getNameSpace(), XML_DEPTH);
        xmlWriter.writeCharacters("Infinity");
        xmlWriter.writeEndElement();
        xmlWriter.writeStartElement(this.getNameSpace(), XML_OWNER);
        xmlWriter.writeCharacters(this.owner);
        xmlWriter.writeEndElement();
        xmlWriter.writeStartElement(this.getNameSpace(), XML_TIMEOUT);
        if (this.timeOut <= 0L) {
            xmlWriter.writeCharacters("Second-2147483647");
        } else {
            xmlWriter.writeCharacters("Second-" + this.timeOut);
        }
        xmlWriter.writeEndElement();
        if (!"".equals(this.lockToken)) {
            xmlWriter.writeStartElement(this.getNameSpace(), XML_LOCKTOKEN);
            HrefRepresentation hrefRepresentation = new HrefRepresentation(this.lockToken);
            hrefRepresentation.write(xmlWriter);
            xmlWriter.writeEndElement();
        }
        xmlWriter.writeEndElement();
    }
}

