/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.order;

import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.webdav.common.util.DavUtil;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OrderMember {
    public static final int POSITION_FIRST = 0;
    public static final int POSITION_LAST = 1;
    public static final int POSITION_BEFORE = 2;
    public static final int POSITION_AFTER = 3;
    private static Log log = ExoLogger.getLogger((String)"jcr.OrderMember");
    public static final String XML_ORDERMEMBER = "order-member";
    private String segment;
    private int position = 0;
    private String positionSegment;
    private int status = 200;

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getSegment() {
        return this.segment;
    }

    public int getPosition() {
        return this.position;
    }

    public String getPositionSegment() {
        return this.positionSegment;
    }

    public boolean initFromDom(Node memberNode) {
        try {
            Node segmentNode = DavUtil.getChildNode(memberNode, "segment");
            this.segment = segmentNode.getTextContent();
            Node positionNode = DavUtil.getChildNode(memberNode, "position");
            NodeList nodes = positionNode.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node positionValNode = nodes.item(i);
                if ("first".equals(positionValNode.getLocalName())) {
                    this.position = 0;
                    return true;
                }
                if ("last".equals(positionValNode.getLocalName())) {
                    this.position = 1;
                    return true;
                }
                if ("before".equals(positionValNode.getLocalName())) {
                    this.position = 2;
                    this.positionSegment = DavUtil.getChildNode(positionValNode, "segment").getTextContent();
                    return true;
                }
                if (!"after".equals(positionValNode.getLocalName())) continue;
                this.position = 3;
                this.positionSegment = DavUtil.getChildNode(positionValNode, "segment").getTextContent();
                return true;
            }
        }
        catch (Exception exc) {
            log.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
        }
        return false;
    }
}

