/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.order.command;

import java.util.ArrayList;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.Node;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.HeaderParam;
import org.exoplatform.services.rest.InputTransformer;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.ResourceDispatcher;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.transformer.SerializableTransformer;
import org.exoplatform.services.webdav.WebDavService;
import org.exoplatform.services.webdav.WebDavXmlInputTransformer;
import org.exoplatform.services.webdav.common.command.WebDavCommand;
import org.exoplatform.services.webdav.common.resource.JCRResourceDispatcher;
import org.exoplatform.services.webdav.order.representation.OrderPatchRepresentationFactory;
import org.exoplatform.services.webdav.order.representation.OrderPatchResponseRepresentation;
import org.w3c.dom.Document;

@URITemplate(value="/jcr/")
public class OrderPatchCommand
extends WebDavCommand {
    public OrderPatchCommand(WebDavService webDavService, ResourceDispatcher resourceDispatcher, ThreadLocalSessionProviderService sessionProviderService) {
        super(webDavService, resourceDispatcher, sessionProviderService);
    }

    @HTTPMethod(value="ORDERPATCH")
    @URITemplate(value="/{repoName}/{repoPath}/")
    @InputTransformer(value=WebDavXmlInputTransformer.class)
    @OutputTransformer(value=SerializableTransformer.class)
    public Response orderPatch(@URIParam(value="repoName") String repoName, @URIParam(value="repoPath") String repoPath, Document document, @HeaderParam(value="Authorization") String authorization, @HeaderParam(value="lock-token") String lockTokenHeader, @HeaderParam(value="If") String ifHeader) {
        try {
            SessionProvider sessionProvider = this.getSessionProvider(authorization);
            ManageableRepository repository = this.webDavService.getRepository(repoName);
            Item item = new JCRResourceDispatcher(sessionProvider, repository).getItem(repoPath);
            if (!(item instanceof Node)) {
                throw new AccessDeniedException();
            }
            ArrayList<String> lockTokens = this.getLockTokens(lockTokenHeader, ifHeader);
            this.tuneSession(item.getSession(), lockTokens);
            String href = this.getHref(repoPath);
            OrderPatchResponseRepresentation orderPatchRepresentation = OrderPatchRepresentationFactory.createResponseRepresentation(document, href, item);
            int status = orderPatchRepresentation.doOrder();
            if (status == 200) {
                return Response.Builder.ok().build();
            }
            return Response.Builder.withStatus((int)207).entity((Object)orderPatchRepresentation, "text/xml").build();
        }
        catch (Exception exc) {
            return this.responseByException(exc);
        }
    }
}

