/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.webdav.search.command;

import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.Node;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.ThreadLocalSessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.HeaderParam;
import org.exoplatform.services.rest.InputTransformer;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.ResourceDispatcher;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.transformer.SerializableTransformer;
import org.exoplatform.services.webdav.WebDavService;
import org.exoplatform.services.webdav.WebDavXmlInputTransformer;
import org.exoplatform.services.webdav.common.command.WebDavCommand;
import org.exoplatform.services.webdav.common.representation.XmlResponseRepresentation;
import org.exoplatform.services.webdav.common.resource.JCRResourceDispatcher;
import org.exoplatform.services.webdav.search.representation.SearchResultRepresentationFactory;
import org.w3c.dom.Document;

@URITemplate(value="/jcr/")
public class SearchCommand
extends WebDavCommand {
    private static Log log = ExoLogger.getLogger((String)"jcr.SearchCommand");

    public SearchCommand(WebDavService webDavService, ResourceDispatcher resourceDispatcher, ThreadLocalSessionProviderService sessionProviderService) {
        super(webDavService, resourceDispatcher, sessionProviderService);
    }

    @HTTPMethod(value="SEARCH")
    @URITemplate(value="/{repoName}/{repoPath}/")
    @InputTransformer(value=WebDavXmlInputTransformer.class)
    @OutputTransformer(value=SerializableTransformer.class)
    public Response search(@URIParam(value="repoName") String repoName, @URIParam(value="repoPath") String repoPath, Document document, @HeaderParam(value="Authorization") String authorization) {
        try {
            SessionProvider sessionProvider = this.getSessionProvider(authorization);
            ManageableRepository repository = this.webDavService.getRepository(repoName);
            Item item = new JCRResourceDispatcher(sessionProvider, repository).getItem(repoPath);
            if (!(item instanceof Node)) {
                throw new AccessDeniedException();
            }
            String href = this.getHref(repoPath);
            XmlResponseRepresentation searchResult = SearchResultRepresentationFactory.createSearchResultRepresentation(this.webDavService, document, item, href);
            return Response.Builder.withStatus((int)207).entity((Object)searchResult, "text/xml").build();
        }
        catch (Exception exc) {
            log.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
            return this.responseByException(exc);
        }
    }
}

