/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command.deltav;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.xml.namespace.QName;
import org.exoplatform.services.jcr.webdav.Depth;
import org.exoplatform.services.jcr.webdav.command.deltav.report.VersionTreeResponseEntity;
import org.exoplatform.services.jcr.webdav.resource.GenericResource;
import org.exoplatform.services.jcr.webdav.resource.HierarchicalProperty;
import org.exoplatform.services.jcr.webdav.resource.ResourceUtil;
import org.exoplatform.services.jcr.webdav.resource.VersionedCollectionResource;
import org.exoplatform.services.jcr.webdav.resource.VersionedFileResource;
import org.exoplatform.services.jcr.webdav.resource.VersionedResource;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.jcr.webdav.xml.WebDavNamespaceContext;
import org.exoplatform.services.rest.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportCommand {
    public Response report(Session session, String path, HierarchicalProperty body, Depth depth, String baseURI) {
        try {
            Node node = (Node)session.getItem(path);
            WebDavNamespaceContext nsContext = new WebDavNamespaceContext(session);
            String strUri = baseURI + node.getPath();
            URI uri = new URI(TextUtil.escape(strUri, '%', true));
            if (!ResourceUtil.isVersioned(node)) {
                return Response.Builder.serverError().build();
            }
            GenericResource resource = ResourceUtil.isFile(node) ? new VersionedFileResource(uri, node, nsContext) : new VersionedCollectionResource(uri, node, nsContext);
            Set<QName> properties = this.getProperties(body);
            VersionTreeResponseEntity response = new VersionTreeResponseEntity(nsContext, (VersionedResource)((Object)resource), properties);
            return Response.Builder.withStatus((int)207).entity((Object)response, "text/xml").build();
        }
        catch (PathNotFoundException exc) {
            return Response.Builder.notFound().build();
        }
        catch (RepositoryException exc) {
            return Response.Builder.serverError().build();
        }
        catch (Exception exc) {
            return Response.Builder.serverError().build();
        }
    }

    protected Set<QName> getProperties(HierarchicalProperty body) {
        HashSet<QName> properties = new HashSet<QName>();
        HierarchicalProperty prop = body.getChild(new QName("DAV:", "prop"));
        if (prop == null) {
            return properties;
        }
        for (int i = 0; i < prop.getChildren().size(); ++i) {
            HierarchicalProperty property = prop.getChild(i);
            properties.add(property.getName());
        }
        return properties;
    }
}

