/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.resource;

import java.io.InputStream;
import java.net.URI;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.xml.namespace.QName;
import org.exoplatform.services.jcr.webdav.resource.GenericResource;
import org.exoplatform.services.jcr.webdav.resource.HierarchicalProperty;
import org.exoplatform.services.jcr.webdav.resource.IllegalResourceTypeException;
import org.exoplatform.services.jcr.webdav.resource.ResourceUtil;
import org.exoplatform.services.jcr.webdav.xml.WebDavNamespaceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileResource
extends GenericResource {
    protected static final Set<String> FILE_SKIP = new HashSet<String>();
    protected static final Set<String> CONTENT_SKIP;
    protected final Node node;

    public FileResource(URI identifier, Node node, WebDavNamespaceContext namespaceContext) throws IllegalResourceTypeException, RepositoryException {
        this(1, identifier, node, namespaceContext);
    }

    protected FileResource(int type, URI identifier, Node node, WebDavNamespaceContext namespaceContext) throws IllegalResourceTypeException, RepositoryException {
        super(type, identifier, namespaceContext);
        if (!ResourceUtil.isFile(node)) {
            throw new IllegalResourceTypeException("Node type is not applicable for FILE resource " + node.getPath());
        }
        this.node = node;
    }

    @Override
    public Set<HierarchicalProperty> getProperties(boolean namesOnly) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        QName name;
        Property property;
        Set<HierarchicalProperty> props = super.getProperties(namesOnly);
        props.add(namesOnly ? new HierarchicalProperty(GETLASTMODIFIED) : this.getProperty(GETLASTMODIFIED));
        props.add(namesOnly ? new HierarchicalProperty(GETCONTENTLENGTH) : this.getProperty(GETCONTENTLENGTH));
        props.add(namesOnly ? new HierarchicalProperty(GETCONTENTTYPE) : this.getProperty(GETCONTENTTYPE));
        HashSet<QName> presents = new HashSet<QName>();
        PropertyIterator jcrProps = this.node.getProperties();
        while (jcrProps.hasNext()) {
            property = jcrProps.nextProperty();
            if (FILE_SKIP.contains(property.getName())) continue;
            name = this.namespaceContext.createQName(property.getName());
            presents.add(name);
            props.add(namesOnly ? new HierarchicalProperty(name) : this.getProperty(name));
        }
        jcrProps = this.contentNode().getProperties();
        while (jcrProps.hasNext()) {
            property = jcrProps.nextProperty();
            if (CONTENT_SKIP.contains(property.getName()) || presents.contains(name = this.namespaceContext.createQName(property.getName()))) continue;
            props.add(namesOnly ? new HierarchicalProperty(name) : this.getProperty(name));
        }
        return props;
    }

    @Override
    public HierarchicalProperty getProperty(QName name) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        if (name.equals(DISPLAYNAME)) {
            return new HierarchicalProperty(name, this.node.getName());
        }
        if (name.equals(CREATIONDATE)) {
            Calendar created = this.node.getProperty("jcr:created").getDate();
            HierarchicalProperty creationDate = new HierarchicalProperty(name, created, "yyyy-MM-dd'T'HH:mm:ss'Z'");
            creationDate.setAttribute("b:dt", "dateTime.tz");
            return creationDate;
        }
        if (name.equals(CHILDCOUNT)) {
            return new HierarchicalProperty(name, "0");
        }
        if (name.equals(GETCONTENTLENGTH)) {
            return new HierarchicalProperty(name, "" + this.node.getNode("jcr:content").getProperty("jcr:data").getLength());
        }
        if (name.equals(GETCONTENTTYPE)) {
            return new HierarchicalProperty(name, this.node.getNode("jcr:content").getProperty("jcr:mimeType").getString());
        }
        if (name.equals(GETLASTMODIFIED)) {
            Calendar modified = this.contentNode().getProperty("jcr:lastModified").getDate();
            HierarchicalProperty lastModified = new HierarchicalProperty(name, modified, "EEE, dd MMM yyyy HH:mm:ss z");
            lastModified.setAttribute("b:dt", "dateTime.rfc1123");
            return lastModified;
        }
        if (name.equals(HASCHILDREN)) {
            return new HierarchicalProperty(name, "0");
        }
        if (name.equals(ISCOLLECTION)) {
            return new HierarchicalProperty(name, "0");
        }
        if (name.equals(ISFOLDER)) {
            return new HierarchicalProperty(name, "0");
        }
        if (name.equals(ISROOT)) {
            return new HierarchicalProperty(name, "0");
        }
        if (name.equals(PARENTNAME)) {
            return new HierarchicalProperty(name, this.node.getParent().getName());
        }
        if (name.equals(RESOURCETYPE)) {
            return new HierarchicalProperty(name);
        }
        if (name.equals(SUPPORTEDLOCK)) {
            if (!this.node.canAddMixin("mix:lockable")) {
                throw new PathNotFoundException();
            }
            return this.supportedLock();
        }
        if (name.equals(LOCKDISCOVERY)) {
            if (this.node.isLocked()) {
                String token = this.node.getLock().getLockToken();
                String owner = this.node.getLock().getLockOwner();
                return FileResource.lockDiscovery(token, owner, "86400");
            }
            throw new PathNotFoundException();
        }
        if (name.equals(ISVERSIONED)) {
            return new HierarchicalProperty(name, "0");
        }
        if (name.equals(SUPPORTEDMETHODSET)) {
            return this.supportedMethodSet();
        }
        try {
            String propertyValue;
            Property property = this.node.getProperty(WebDavNamespaceContext.createName(name));
            if (property.getDefinition().isMultiple()) {
                if (property.getValues().length == 0) {
                    throw new PathNotFoundException();
                }
                propertyValue = property.getValues()[0].getString();
            } else {
                propertyValue = property.getString();
            }
            return new HierarchicalProperty(name, propertyValue);
        }
        catch (PathNotFoundException e) {
            Property property = this.contentNode().getProperty(WebDavNamespaceContext.createName(name));
            String propertyValue = property.getDefinition().isMultiple() ? property.getValues()[0].getString() : property.getString();
            return new HierarchicalProperty(name, propertyValue);
        }
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    public String getContentAsText() throws RepositoryException {
        return this.contentNode().getProperty("jcr:data").getString();
    }

    public InputStream getContentAsStream() throws RepositoryException {
        return this.contentNode().getProperty("jcr:data").getStream();
    }

    public boolean isTextContent() {
        try {
            return this.contentNode().getProperty("jcr:data").getType() != 2;
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return false;
        }
    }

    public Node contentNode() throws RepositoryException {
        return this.node.getNode("jcr:content");
    }

    static {
        FILE_SKIP.add("jcr:primaryType");
        FILE_SKIP.add("jcr:mixinTypes");
        FILE_SKIP.add("jcr:created");
        CONTENT_SKIP = new HashSet<String>();
        CONTENT_SKIP.add("jcr:primaryType");
        CONTENT_SKIP.add("jcr:mixinTypes");
        CONTENT_SKIP.add("jcr:data");
        CONTENT_SKIP.add("jcr:lastModified");
        CONTENT_SKIP.add("jcr:mimeType");
        CONTENT_SKIP.add("jcr:uuid");
    }
}

