/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.xml.namespace.QName;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.services.jcr.webdav.command.propfind.PropFindRequestEntity;
import org.exoplatform.services.jcr.webdav.command.propfind.PropFindResponseEntity;
import org.exoplatform.services.jcr.webdav.resource.CollectionResource;
import org.exoplatform.services.jcr.webdav.resource.FileResource;
import org.exoplatform.services.jcr.webdav.resource.GenericResource;
import org.exoplatform.services.jcr.webdav.resource.ResourceUtil;
import org.exoplatform.services.jcr.webdav.resource.VersionedCollectionResource;
import org.exoplatform.services.jcr.webdav.resource.VersionedFileResource;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.jcr.webdav.xml.WebDavNamespaceContext;
import org.exoplatform.services.rest.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropFindCommand {
    public Response propfind(Session session, String path, HierarchicalProperty body, int depth, String baseURI) {
        PropFindResponseEntity response;
        GenericResource resource;
        Node node;
        try {
            node = (Node)session.getItem(path);
        }
        catch (PathNotFoundException e) {
            return Response.Builder.withStatus((int)404).build();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return Response.Builder.serverError().errorMessage(e.getMessage()).build();
        }
        try {
            WebDavNamespaceContext nsContext = new WebDavNamespaceContext(session);
            resource = null;
            URI uri = "/".equals(node.getPath()) ? new URI(TextUtil.escape(baseURI, '%', true)) : new URI(TextUtil.escape(baseURI + node.getPath(), '%', true));
            resource = ResourceUtil.isVersioned(node) ? (ResourceUtil.isFile(node) ? new VersionedFileResource(uri, node, nsContext) : new VersionedCollectionResource(uri, node, nsContext)) : (ResourceUtil.isFile(node) ? new FileResource(uri, node, nsContext) : new CollectionResource(uri, node, nsContext));
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return Response.Builder.serverError().errorMessage(e1.getMessage()).build();
        }
        PropFindRequestEntity request = new PropFindRequestEntity(body);
        if (request.getType().equalsIgnoreCase("allprop")) {
            response = new PropFindResponseEntity(depth, resource, null, false);
        } else if (request.getType().equalsIgnoreCase("propnames")) {
            response = new PropFindResponseEntity(depth, resource, null, true);
        } else if (request.getType().equalsIgnoreCase("prop")) {
            response = new PropFindResponseEntity(depth, resource, this.propertyNames(body), false);
        } else {
            return Response.Builder.badRequest().errorMessage("Unexpected property name " + request.getType()).build();
        }
        return Response.Builder.withStatus((int)207).entity((Object)response, "text/xml").build();
    }

    private Set<QName> propertyNames(HierarchicalProperty body) {
        HashSet<QName> names = new HashSet<QName>();
        HierarchicalProperty propBody = body.getChild(0);
        List properties = propBody.getChildren();
        for (HierarchicalProperty property : properties) {
            names.add(property.getName());
        }
        return names;
    }
}

