/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command.deltav.report;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.ws.rs.core.StreamingOutput;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.jcr.webdav.resource.IllegalResourceTypeException;
import org.exoplatform.services.jcr.webdav.resource.VersionResource;
import org.exoplatform.services.jcr.webdav.resource.VersionedResource;
import org.exoplatform.services.jcr.webdav.xml.PropertyWriteUtil;
import org.exoplatform.services.jcr.webdav.xml.PropstatGroupedRepresentation;
import org.exoplatform.services.jcr.webdav.xml.WebDavNamespaceContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class VersionTreeResponseEntity
implements StreamingOutput {
    private static Log log = ExoLogger.getLogger((String)"exo.jcr.component.webdav.VersionTreeResponseEntity");
    protected XMLStreamWriter xmlStreamWriter;
    protected final WebDavNamespaceContext namespaceContext;
    private Set<VersionResource> versions;
    private Set<QName> properties;

    public VersionTreeResponseEntity(WebDavNamespaceContext namespaceContext, VersionedResource versionedResource, Set<QName> properties) throws RepositoryException, IllegalResourceTypeException {
        this.namespaceContext = namespaceContext;
        this.properties = properties;
        this.versions = versionedResource.getVersionHistory().getVersions();
    }

    public void write(OutputStream outputStream) throws IOException {
        try {
            this.xmlStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(outputStream, "UTF-8");
            this.xmlStreamWriter.setNamespaceContext(this.namespaceContext);
            this.xmlStreamWriter.writeStartDocument();
            this.xmlStreamWriter.writeStartElement("D", "multistatus", "DAV:");
            this.xmlStreamWriter.writeNamespace("D", "DAV:");
            this.xmlStreamWriter.writeAttribute("xmlns:b", "urn:uuid:c2f41010-65b3-11d1-a29f-00aa00c14882/");
            for (VersionResource versionResource : this.versions) {
                this.xmlStreamWriter.writeStartElement("DAV:", "response");
                this.xmlStreamWriter.writeStartElement("DAV:", "href");
                this.xmlStreamWriter.writeCharacters(versionResource.getIdentifier().toASCIIString());
                this.xmlStreamWriter.writeEndElement();
                PropstatGroupedRepresentation propstat = new PropstatGroupedRepresentation(versionResource, this.properties, false);
                PropertyWriteUtil.writePropStats(this.xmlStreamWriter, propstat.getPropStats());
                this.xmlStreamWriter.writeEndElement();
            }
            this.xmlStreamWriter.writeEndElement();
            this.xmlStreamWriter.writeEndDocument();
        }
        catch (XMLStreamException exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            throw new IOException(exc.getMessage(), exc);
        }
        catch (RepositoryException exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
            throw new IOException(exc.getMessage(), exc);
        }
    }
}

