/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command.propfind;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.ws.rs.core.StreamingOutput;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.jcr.webdav.resource.CollectionResource;
import org.exoplatform.services.jcr.webdav.resource.IllegalResourceTypeException;
import org.exoplatform.services.jcr.webdav.resource.Resource;
import org.exoplatform.services.jcr.webdav.xml.PropertyWriteUtil;
import org.exoplatform.services.jcr.webdav.xml.PropstatGroupedRepresentation;
import org.exoplatform.services.jcr.webdav.xml.WebDavNamespaceContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class PropFindResponseEntity
implements StreamingOutput {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.webdav.PropFindResponseEntity");
    protected XMLStreamWriter xmlStreamWriter;
    protected OutputStream outputStream;
    protected final WebDavNamespaceContext namespaceContext;
    protected final Resource rootResource;
    protected Set<QName> propertyNames;
    protected final int depth;
    protected final boolean propertyNamesOnly;
    protected final Session session;

    public PropFindResponseEntity(int depth, Resource rootResource, Set<QName> propertyNames, boolean propertyNamesOnly, Session session) {
        this.rootResource = rootResource;
        this.namespaceContext = rootResource.getNamespaceContext();
        this.propertyNames = propertyNames;
        this.depth = depth;
        this.propertyNamesOnly = propertyNamesOnly;
        this.session = session;
    }

    public PropFindResponseEntity(int depth, Resource rootResource, Set<QName> propertyNames, boolean propertyNamesOnly) {
        this(depth, rootResource, propertyNames, propertyNamesOnly, null);
    }

    public void write(OutputStream stream) throws IOException {
        this.outputStream = stream;
        try {
            this.xmlStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(this.outputStream, "UTF-8");
            this.xmlStreamWriter.setNamespaceContext(this.namespaceContext);
            this.xmlStreamWriter.writeStartDocument();
            this.xmlStreamWriter.writeStartElement("D", "multistatus", "DAV:");
            this.xmlStreamWriter.writeNamespace("D", "DAV:");
            this.xmlStreamWriter.writeAttribute("xmlns:b", "urn:uuid:c2f41010-65b3-11d1-a29f-00aa00c14882/");
            this.traverseResources(this.rootResource, 0);
            this.xmlStreamWriter.writeEndElement();
            this.xmlStreamWriter.writeEndDocument();
        }
        catch (XMLStreamException exc) {
            LOG.error((Object)exc.getMessage(), (Throwable)exc);
            throw new IOException(exc.getMessage(), exc);
        }
        catch (RepositoryException exc) {
            LOG.error((Object)exc.getMessage(), (Throwable)exc);
            throw new IOException(exc.getMessage(), exc);
        }
        catch (IllegalResourceTypeException exc) {
            LOG.error((Object)exc.getMessage(), (Throwable)exc);
            throw new IOException(exc.getMessage(), exc);
        }
        catch (URISyntaxException exc) {
            LOG.error((Object)exc.getMessage(), (Throwable)exc);
            throw new IOException(exc.getMessage(), exc);
        }
    }

    private void traverseResources(Resource resource, int counter) throws XMLStreamException, RepositoryException, IllegalResourceTypeException, URISyntaxException, UnsupportedEncodingException {
        this.xmlStreamWriter.writeStartElement("DAV:", "response");
        this.xmlStreamWriter.writeStartElement("DAV:", "href");
        String href = resource.getIdentifier().toASCIIString();
        if (resource.isCollection()) {
            this.xmlStreamWriter.writeCharacters(href + "/");
        } else {
            this.xmlStreamWriter.writeCharacters(href);
        }
        this.xmlStreamWriter.writeEndElement();
        PropstatGroupedRepresentation propstat = new PropstatGroupedRepresentation(resource, this.propertyNames, this.propertyNamesOnly, this.session);
        PropertyWriteUtil.writePropStats(this.xmlStreamWriter, propstat.getPropStats());
        this.xmlStreamWriter.writeEndElement();
        int d = this.depth;
        if (resource.isCollection() && counter < d) {
            CollectionResource collection = (CollectionResource)resource;
            for (Resource child : collection.getResources()) {
                this.traverseResources(child, counter + 1);
            }
        }
    }
}

