/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.ws.rs.core.MultivaluedMap;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.CredentialsImpl;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.impl.core.version.VersionImpl;
import org.exoplatform.services.jcr.webdav.BaseStandaloneTest;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.jcr.webdav.utils.TestUtils;
import org.exoplatform.services.rest.ext.provider.XSLTStreamingOutput;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.security.IdentityConstants;

public class TestGet
extends BaseStandaloneTest {
    private String path = TestUtils.getFileName();
    private String fileContent = TestUtils.getFileContent();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.session.getRootNode().addNode(TextUtil.relativizePath((String)this.path));
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.fileContent.getBytes());
        TestUtils.addContent((Session)this.session, this.path, inputStream, this.defaultFileNodeType, "");
        this.path = this.path + "[2]";
    }

    public void testSimpleGet() throws Exception {
        this.testSimpleGet(this.getPathWS());
    }

    public void testSimpleGetWithFakePathWS() throws Exception {
        this.testSimpleGet(this.getFakePathWS());
    }

    private void testSimpleGet(String pathWs) throws Exception {
        int n;
        ContainerResponse response = this.serviceWithEscape("GET", pathWs + this.path, "", null, null);
        TestGet.assertEquals((int)200, (int)response.getStatus());
        FileInputStream content = (FileInputStream)response.getEntity();
        InputStreamReader r = new InputStreamReader(content);
        StringWriter sw = new StringWriter();
        char[] buffer = new char[1024];
        while ((n = r.read(buffer)) != -1) {
            sw.write(buffer, 0, n);
        }
        String str = sw.toString();
        TestGet.assertEquals((String)this.fileContent, (String)str);
    }

    public void testNotFoundGet() throws Exception {
        ContainerResponse response = this.serviceWithEscape("GET", this.getPathWS() + "/not-found" + this.path, "", null, null);
        TestGet.assertEquals((int)404, (int)response.getStatus());
    }

    public void testFolderListingAllowed() throws Exception {
        TestUtils.addFolder((Session)this.session2, "/folder1", this.defaultFolderNodeType, "");
        ContainerResponse response = this.serviceWithEscape("GET", this.getPathWS() + "2/folder1" + this.path, "", null, null);
        TestGet.assertEquals((int)404, (int)response.getStatus());
        response = this.serviceWithEscape("GET", this.getPathWS() + "2/folder1/folder2" + this.path, "", null, null);
        TestGet.assertEquals((int)404, (int)response.getStatus());
        TestUtils.addFolder((Session)this.session2, "/folder1/folder2", this.defaultFolderNodeType, "");
        TestUtils.addFolder((Session)this.session2, "/folder1/folder2/folder3", this.defaultFolderNodeType, "");
        response = this.serviceWithEscape("GET", this.getPathWS() + "2/folder1/folder2/folder3", "", null, null);
        TestGet.assertEquals((int)200, (int)response.getStatus());
    }

    public void testMissingJcrLastModifiedProperty() throws Exception {
        File file = new File("src/test/resources/rh_nodetype.xml");
        TestGet.assertTrue((String)"src/test/resources/rh_nodetype.xml not found", (boolean)file.exists());
        FileInputStream fis = new FileInputStream(file);
        this.session.getWorkspace().getNamespaceRegistry().registerNamespace("rh", "www.vn.vnn");
        this.session.getWorkspace().getNodeTypesHolder().registerNodeTypes((InputStream)fis, 0, "text/xml");
        Node podcast = this.session.getRootNode().addNode("podcast", "rh:podcast");
        Node nodeToAdd = podcast.addNode("rh:podcastFile", "nt:file");
        Node contentNodeOfNodeToAdd = nodeToAdd.addNode("jcr:content", "nt:resource");
        contentNodeOfNodeToAdd.setProperty("jcr:data", (InputStream)new FileInputStream("src/test/resources/test.txt"));
        contentNodeOfNodeToAdd.setProperty("jcr:mimeType", "text/plain");
        contentNodeOfNodeToAdd.setProperty("jcr:lastModified", Calendar.getInstance());
        this.session.save();
        podcast.addMixin("mix:versionable");
        this.session.save();
        VersionImpl v = (VersionImpl)podcast.checkin();
        this.session.save();
        podcast.checkout();
        this.session.save();
        String path = this.getPathWS() + "/jcr:system/jcr:versionStorage/" + v.getContainingHistory().getIdentifier() + "/1/jcr:frozenNode/rh:podcastFile";
        ContainerResponse response = this.serviceWithEscape("GET", path, "", null, null);
        TestGet.assertEquals((String)("Successful result expected (200), but actual is: " + response.getStatus()), (int)200, (int)response.getStatus());
    }

    public void testIfModifiedSinceDateParsing() throws Exception {
        this.session.getRootNode().addNode("node");
        Node fileNode = this.session.getRootNode().addNode("node", "nt:file");
        fileNode.addMixin("mix:versionable");
        Node contentNode = fileNode.addNode("jcr:content", "nt:resource");
        contentNode.setProperty("jcr:mimeType", "text/plain");
        Calendar creationDate = Calendar.getInstance();
        Calendar IfModifiedSince = Calendar.getInstance();
        IfModifiedSince.add(10, -2);
        creationDate.add(10, -1);
        contentNode.setProperty("jcr:data", creationDate);
        contentNode.setProperty("jcr:lastModified", creationDate);
        this.session.save();
        fileNode.checkin();
        fileNode.checkout();
        String path = this.getPathWS() + "/" + fileNode.getName() + "[2]?time=" + IfModifiedSince.getTimeInMillis() + "&version=1";
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        String ifModifiedSinceDate = dateFormat.format(IfModifiedSince.getTime());
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"If-Modified-Since", (Object)ifModifiedSinceDate);
        ContainerResponse response = this.serviceWithEscape("GET", path, "", (MultivaluedMap<String, String>)headers, null);
        TestGet.assertEquals((int)200, (int)response.getStatus());
        headers.clear();
        IfModifiedSince.add(10, 4);
        ifModifiedSinceDate = dateFormat.format(IfModifiedSince.getTime());
        headers.add((Object)"If-Modified-Since", (Object)ifModifiedSinceDate);
        response = this.serviceWithEscape("GET", path, "", (MultivaluedMap<String, String>)headers, null);
        TestGet.assertEquals((int)304, (int)response.getStatus());
    }

    public void testXSLTParamsPassing() throws Exception {
        String strToTest = "/absolute/path/to/file";
        String folderName = TestUtils.getFolderName();
        TestUtils.addFolder((Session)this.session, folderName, this.defaultFolderNodeType, "");
        ContainerResponse response = this.serviceWithEscape("GET", this.getPathWS() + folderName, "", null, null);
        TestGet.assertEquals((int)200, (int)response.getStatus());
        XSLTStreamingOutput XSLTout = (XSLTStreamingOutput)response.getEntity();
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        XSLTout.write((OutputStream)byteOut);
        TestGet.assertTrue((boolean)byteOut.toString().contains(strToTest));
    }

    public void testParentHrefForGetColRequest() throws Exception {
        String folderOne = TestUtils.getFolderName();
        String folderTwo = folderOne + TestUtils.getFolderName();
        TestUtils.addFolder((Session)this.session, folderOne, this.defaultFolderNodeType, "");
        TestUtils.addFolder((Session)this.session, folderTwo, this.defaultFolderNodeType, "");
        ContainerResponse response = this.serviceWithEscape("GET", this.getPathWS() + folderTwo, "", null, null);
        TestGet.assertEquals((int)200, (int)response.getStatus());
        XSLTStreamingOutput XSLTout = (XSLTStreamingOutput)response.getEntity();
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        XSLTout.write((OutputStream)byteOut);
        TestGet.assertTrue((String)"Response should contain parent collection href", (boolean)byteOut.toString().contains(folderOne));
    }

    public void testParentHrefForGetColWithNonLatinNameRequest() throws Exception {
        String folderOne = TestUtils.getFolderName() + "%40";
        String folderTwo = folderOne + TestUtils.getFolderName() + "%40";
        TestUtils.addFolder((Session)this.session, URLDecoder.decode(folderOne, "UTF-8"), this.defaultFolderNodeType, "");
        TestUtils.addFolder((Session)this.session, URLDecoder.decode(folderTwo, "UTF-8"), this.defaultFolderNodeType, "");
        ContainerResponse response = this.service("GET", this.getPathWS() + folderTwo, "", null, null);
        TestGet.assertEquals((int)200, (int)response.getStatus());
        XSLTStreamingOutput XSLTout = (XSLTStreamingOutput)response.getEntity();
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        XSLTout.write((OutputStream)byteOut);
        TestGet.assertTrue((String)"Response should contain parent collection href", (boolean)byteOut.toString().contains(folderOne));
    }

    @Override
    protected String getRepositoryName() {
        return null;
    }

    public void testGetFileFromFolder() throws Exception {
        ExtendedNode folderA = (ExtendedNode)this.session.getRootNode().addNode("folderA", "nt:folder");
        folderA.addMixin("exo:privilegeable");
        folderA.setPermission("john", PermissionType.ALL);
        folderA.removePermission(IdentityConstants.ANY);
        this.session.save();
        TestGet.assertEquals((int)4, (int)folderA.getACL().getPermissionEntries().size());
        TestGet.assertEquals((String)"john read", (String)((AccessControlEntry)folderA.getACL().getPermissionEntries().get(0)).getAsString());
        TestGet.assertEquals((String)"john add_node", (String)((AccessControlEntry)folderA.getACL().getPermissionEntries().get(1)).getAsString());
        TestGet.assertEquals((String)"john set_property", (String)((AccessControlEntry)folderA.getACL().getPermissionEntries().get(2)).getAsString());
        TestGet.assertEquals((String)"john remove", (String)((AccessControlEntry)folderA.getACL().getPermissionEntries().get(3)).getAsString());
        Session sessJohn = this.repository.login((Credentials)new CredentialsImpl("john", "exo".toCharArray()), "ws");
        ExtendedNode folderB = (ExtendedNode)sessJohn.getRootNode().getNode("folderA").addNode("folderB", "nt:folder");
        folderB.addMixin("exo:privilegeable");
        folderB.setPermission("any", new String[]{"read"});
        sessJohn.save();
        TestGet.assertEquals((int)5, (int)folderB.getACL().getPermissionEntries().size());
        TestGet.assertEquals((String)"john read", (String)((AccessControlEntry)folderB.getACL().getPermissionEntries().get(0)).getAsString());
        TestGet.assertEquals((String)"john add_node", (String)((AccessControlEntry)folderB.getACL().getPermissionEntries().get(1)).getAsString());
        TestGet.assertEquals((String)"john set_property", (String)((AccessControlEntry)folderB.getACL().getPermissionEntries().get(2)).getAsString());
        TestGet.assertEquals((String)"john remove", (String)((AccessControlEntry)folderB.getACL().getPermissionEntries().get(3)).getAsString());
        TestGet.assertEquals((String)"any read", (String)((AccessControlEntry)folderB.getACL().getPermissionEntries().get(4)).getAsString());
        this.repository.login((Credentials)new CredentialsImpl(IdentityConstants.ANONIM, "exo".toCharArray()), "ws");
        String path = this.getPathWS() + "/folderA/folderB";
        ContainerResponse response = this.serviceWithEscape("GET", path, "", null, null);
        TestGet.assertEquals((String)("Successful result expected (200), but actual is: " + response.getStatus()), (int)200, (int)response.getStatus());
        XSLTStreamingOutput XSLTout = (XSLTStreamingOutput)response.getEntity();
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        XSLTout.write((OutputStream)byteOut);
        TestGet.assertTrue((String)"Response should contain parent collection href", (boolean)byteOut.toString().contains("folderA"));
    }

    public void testGetContentTypeWithEncoding() throws Exception {
        Node fileNode = this.session.getRootNode().addNode("node", "nt:file");
        Node contentNode = fileNode.addNode("jcr:content", "nt:resource");
        contentNode.setProperty("jcr:mimeType", "text/plain");
        contentNode.setProperty("jcr:encoding", "test-encoding");
        contentNode.setProperty("jcr:data", "There is no ignorance, there is knowledge.");
        contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
        this.session.save();
        ContainerResponse response = this.service("GET", this.getPathWS() + "/" + fileNode.getName(), "", null, null);
        TestGet.assertEquals((String)"text/plain; charset=test-encoding", (String)response.getHttpHeaders().getFirst((Object)"Content-Type").toString());
    }

    public void testGetContentTypeWithNoEncoding() throws Exception {
        Node fileNode = this.session.getRootNode().addNode("node", "nt:file");
        Node contentNode = fileNode.addNode("jcr:content", "nt:resource");
        contentNode.setProperty("jcr:mimeType", "text/plain");
        contentNode.setProperty("jcr:encoding", "");
        contentNode.setProperty("jcr:data", "There is no passion, there is serenity.");
        contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
        this.session.save();
        ContainerResponse response = this.service("GET", this.getPathWS() + "/" + fileNode.getName(), "", null, null);
        TestGet.assertEquals((String)"text/plain", (String)response.getHttpHeaders().getFirst((Object)"Content-Type").toString());
        fileNode = this.session.getRootNode().addNode("node2", "nt:file");
        contentNode = fileNode.addNode("jcr:content", "nt:resource");
        contentNode.setProperty("jcr:mimeType", "text/plain");
        contentNode.setProperty("jcr:data", "There is no passion, there is serenity.");
        contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
        this.session.save();
        response = this.service("GET", this.getPathWS() + "/" + fileNode.getName(), "", null, null);
        TestGet.assertEquals((String)"text/plain", (String)response.getHttpHeaders().getFirst((Object)"Content-Type").toString());
    }

    public void testETag() throws Exception {
        Node fileNodeI = this.session.getRootNode().addNode("node1", "nt:file");
        Node contentNode = fileNodeI.addNode("jcr:content", "nt:resource");
        contentNode.setProperty("jcr:mimeType", "text/plain");
        contentNode.setProperty("jcr:encoding", "");
        contentNode.setProperty("jcr:data", "test1");
        contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
        this.session.save();
        Node fileNodeII = this.session.getRootNode().addNode("node2", "nt:file");
        contentNode = fileNodeII.addNode("jcr:content", "nt:resource");
        contentNode.setProperty("jcr:mimeType", "text/plain");
        contentNode.setProperty("jcr:encoding", "");
        contentNode.setProperty("jcr:data", "test2");
        contentNode.setProperty("jcr:lastModified", Calendar.getInstance());
        this.session.save();
        ContainerResponse response = this.service("GET", this.getPathWS() + "/node1", "", null, null);
        TestGet.assertEquals((int)200, (int)response.getStatus());
        String eTag = (String)response.getHttpHeaders().getFirst((Object)"ETag");
        TestGet.assertNotNull((Object)eTag);
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"If-None-Match", (Object)eTag);
        response = this.service("GET", this.getPathWS() + "/node1", "", (MultivaluedMap<String, String>)headers, null);
        TestGet.assertEquals((int)304, (int)response.getStatus());
        String destAbsPath = fileNodeI.getPath();
        fileNodeI.remove();
        this.session.save();
        this.session.move(fileNodeII.getPath(), destAbsPath);
        this.session.save();
        response = this.service("GET", this.getPathWS() + "/node1", "", (MultivaluedMap<String, String>)headers, null);
        TestGet.assertEquals((int)200, (int)response.getStatus());
        eTag = (String)response.getHttpHeaders().getFirst((Object)"ETag");
        headers.clear();
        headers.add((Object)"If-None-Match", (Object)eTag);
        this.session.move(destAbsPath, destAbsPath + "_");
        this.session.save();
        response = this.service("GET", this.getPathWS() + "/node1_", "", (MultivaluedMap<String, String>)headers, null);
        TestGet.assertEquals((int)304, (int)response.getStatus());
    }
}

