/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command.order;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import javax.jcr.Node;
import javax.xml.namespace.QName;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.services.jcr.webdav.WebDavConst;
import org.exoplatform.services.jcr.webdav.command.order.OrderPatchResponseEntity;
import org.exoplatform.services.jcr.webdav.command.order.OrderPatchTest;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.rest.ext.provider.HierarchicalPropertyEntityProvider;
import org.exoplatform.services.rest.impl.ContainerResponse;

public class TestOrderFirst
extends OrderPatchTest {
    protected Node orderFirstNode;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.session.refresh(false);
        if (this.orderFirstNode == null) {
            this.orderFirstNode = this.orderPatchNode.addNode("orderFirstNode", "nt:unstructured");
            this.session.save();
            for (int i = 1; i <= 5; ++i) {
                this.orderFirstNode.addNode("n" + i, "nt:unstructured");
            }
            this.session.save();
        }
    }

    public void testOrderFirst1() throws Exception {
        this.assertOrder(this.orderFirstNode, new String[]{"n1", "n2", "n3", "n4", "n5"});
        String path = this.orderFirstNode.getPath();
        String xml = "<D:orderpatch xmlns:D=\"DAV:\"><D:order-member><D:segment>n3</D:segment><D:position><D:first/></D:position></D:order-member></D:orderpatch>";
        ContainerResponse response = this.service("ORDERPATCH", this.getPathWS() + URLEncoder.encode(path, "UTF-8"), "", null, xml.getBytes());
        TestOrderFirst.assertEquals((int)200, (int)response.getStatus());
        this.assertOrder(this.orderFirstNode, new String[]{"n3", "n1", "n2", "n4", "n5"});
    }

    public void testOrderFirst2() throws Exception {
        this.assertOrder(this.orderFirstNode, new String[]{"n1", "n2", "n3", "n4", "n5"});
        String path = this.orderFirstNode.getPath();
        String xml = "<D:orderpatch xmlns:D=\"DAV:\"><D:order-member><D:segment>n1</D:segment><D:position><D:first/></D:position></D:order-member></D:orderpatch>";
        ContainerResponse response = this.service("ORDERPATCH", this.getPathWS() + URLEncoder.encode(path, "UTF-8"), "", null, xml.getBytes());
        TestOrderFirst.assertEquals((int)200, (int)response.getStatus());
        this.assertOrder(this.orderFirstNode, new String[]{"n1", "n2", "n3", "n4", "n5"});
    }

    public void testOrderFirst3() throws Exception {
        this.assertOrder(this.orderFirstNode, new String[]{"n1", "n2", "n3", "n4", "n5"});
        String path = this.orderFirstNode.getPath();
        String xml = "<D:orderpatch xmlns:D=\"DAV:\"><D:order-member><D:segment>n0</D:segment><D:position><D:first/></D:position></D:order-member></D:orderpatch>";
        ContainerResponse response = this.service("ORDERPATCH", this.getPathWS() + URLEncoder.encode(path, "UTF-8"), "", null, xml.getBytes());
        TestOrderFirst.assertEquals((int)207, (int)response.getStatus());
        OrderPatchResponseEntity entity = (OrderPatchResponseEntity)response.getEntity();
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        entity.write((OutputStream)outStream);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        entity.write((OutputStream)outputStream);
        String resp = outputStream.toString();
        HierarchicalPropertyEntityProvider entityProvider = new HierarchicalPropertyEntityProvider();
        HierarchicalProperty multistatus = entityProvider.readFrom(null, null, null, null, null, (InputStream)new ByteArrayInputStream(resp.getBytes()));
        TestOrderFirst.assertEquals((int)1, (int)multistatus.getChildren().size());
        TestOrderFirst.assertEquals((Object)new QName("DAV:", "response"), (Object)multistatus.getChild(0).getName());
        String hrefMustBe = TextUtil.escape((String)(this.getPathWS() + this.orderFirstNode.getPath() + "/n0"), (char)'%', (boolean)true);
        HierarchicalProperty r = multistatus.getChild(0);
        String href = r.getChild(new QName("DAV:", "href")).getValue();
        TestOrderFirst.assertEquals((String)hrefMustBe, (String)href);
        String statusMustBe = WebDavConst.getStatusDescription((int)403);
        String status = r.getChild(new QName("DAV:", "status")).getValue();
        TestOrderFirst.assertEquals((String)statusMustBe, (String)status);
        this.assertOrder(this.orderFirstNode, new String[]{"n1", "n2", "n3", "n4", "n5"});
    }
}

