/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.command;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.xml.namespace.QName;
import org.exoplatform.common.util.HierarchicalProperty;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.webdav.BaseStandaloneTest;
import org.exoplatform.services.jcr.webdav.command.PropFindCommand;
import org.exoplatform.services.jcr.webdav.command.acl.ACLProperties;
import org.exoplatform.services.jcr.webdav.command.propfind.PropFindResponseEntity;
import org.exoplatform.services.jcr.webdav.util.TextUtil;
import org.exoplatform.services.jcr.webdav.utils.TestUtils;
import org.exoplatform.services.rest.RequestHandler;
import org.exoplatform.services.rest.ext.provider.HierarchicalPropertyEntityProvider;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.rest.impl.RequestHandlerImpl;
import org.exoplatform.services.rest.tools.DummySecurityContext;
import org.exoplatform.services.rest.tools.ResourceLauncher;

public class TestPropFind
extends BaseStandaloneTest {
    protected Node testPropFind;
    private static final String AUTHOR = "eXoPlatform";
    private static final String WEBDAV_AUTHOR_PROPERTY = "webdav:Author";
    private static final String WEBDAV_NT_FILE = "webdav:file";
    private static final String WEBDAV_NT_RESOURCE = "exo:testResource";
    private static final String WEBDAV_TEST_PROPERTY = "webdav:test-property";
    private static final String CONTENT_TYPE = "text/xml";
    private static final String USER_ROOT = "root";
    private static final String USER_JOHN = "john";
    private static final String BASE_URI = "http://localhost";
    private String propFindXML = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:propfind xmlns:D=\"DAV:\"><D:prop xmlns:webdav=\"http://www.exoplatform.org/jcr/webdav\"><webdav:Author/><webdav:author/><webdave:DingALing/></D:prop></D:propfind>";
    private String multiPropFindXML = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:propfind xmlns:D=\"DAV:\"><D:prop xmlns:webdav=\"http://www.exoplatform.org/jcr/webdav\"><webdav:test-property/></D:prop></D:propfind>";
    private String propnameXML = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><propfind xmlns=\"DAV:\"><propname/></propfind>";
    private String allPropsXML = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:propfind xmlns:D=\"DAV:\"><D:allprop/></D:propfind>";
    private String allPropsWithInclusionXML = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:propfind xmlns:D=\"DAV:\"><D:allprop/><D:include><D:lockdiscovery/><D:supported-method-set/></D:include></D:propfind>";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.testPropFind = this.root.addNode("TestPropFind");
    }

    public void testPropfindComplexContent() throws Exception {
        String path = this.testPropFind.getPath() + "/testPropfindComplexContent";
        this.session.getRootNode().addNode(TextUtil.relativizePath((String)path));
        Node node = TestUtils.addContent((Session)this.session, path, new ByteArrayInputStream("file content".getBytes()), "nt:file", WEBDAV_NT_RESOURCE, "text/plain");
        path = path + "[2]";
        node.getNode("jcr:content").addNode("node", "nt:unstructured").setProperty("node-prop", "prop");
        node.getNode("jcr:content").setProperty("exo:prop", "prop");
        HierarchicalProperty body = new HierarchicalProperty("D:propfind", null, "DAV:");
        body.addChild(new HierarchicalProperty("D:allprop", null, "DAV:"));
        Response resp = new PropFindCommand().propfind((Session)this.session, path, body, -1, BASE_URI);
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        ((PropFindResponseEntity)resp.getEntity()).write((OutputStream)bas);
    }

    public void testSimplePropFind() throws Exception {
        String content = TestUtils.getFileContent();
        Object file = TestUtils.getFileName();
        this.session.getRootNode().addNode(TextUtil.relativizePath((String)file));
        TestUtils.addContent((Session)this.session, (String)file, new ByteArrayInputStream(content.getBytes()), WEBDAV_NT_FILE, "");
        file = (String)file + "[2]";
        ContainerResponse containerResponseFind = this.serviceWithEscape("PROPFIND", this.getPathWS() + (String)file, "", null, null);
        TestPropFind.assertEquals((int)207, (int)containerResponseFind.getStatus());
    }

    public void testSimplePropFindWithNonLatin() throws Exception {
        this.testSimplePropFindWithNonLatin(this.getPathWS());
    }

    public void testSimplePropFindWithNonLatinWithFakePathWS() throws Exception {
        this.testSimplePropFindWithNonLatin(this.getFakePathWS());
    }

    private void testSimplePropFindWithNonLatin(String pathWs) throws Exception {
        String encodedfileName = "%e3%81%82%e3%81%84%e3%81%86%e3%81%88%e3%81%8a";
        String decodedfileName = URLDecoder.decode(encodedfileName, "UTF-8");
        String content = TestUtils.getFileContent();
        TestUtils.addContent((Session)this.session, decodedfileName, new ByteArrayInputStream(content.getBytes()), WEBDAV_NT_FILE, "");
        TestUtils.addNodeProperty((Session)this.session, decodedfileName, WEBDAV_AUTHOR_PROPERTY, AUTHOR);
        ContainerResponse response = this.service("PROPFIND", pathWs + "/" + encodedfileName, "", null, this.allPropsXML.getBytes());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PropFindResponseEntity entity = (PropFindResponseEntity)response.getEntity();
        entity.write((OutputStream)outputStream);
        String resp = outputStream.toString("UTF-8");
        TestPropFind.assertTrue((boolean)resp.contains(encodedfileName));
        TestPropFind.assertTrue((boolean)resp.contains(decodedfileName));
    }

    public void testPropFind() throws Exception {
        String content = TestUtils.getFileContent();
        String file = TestUtils.getFileName();
        TestUtils.addContent((Session)this.session, file, new ByteArrayInputStream(content.getBytes()), WEBDAV_NT_FILE, "");
        TestUtils.addNodeProperty((Session)this.session, file, WEBDAV_AUTHOR_PROPERTY, AUTHOR);
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Content-Type", (Object)CONTENT_TYPE);
        ContainerResponse responseFind = this.service("PROPFIND", this.getPathWS() + file, "", (MultivaluedMap<String, String>)headers, this.propFindXML.getBytes());
        TestPropFind.assertEquals((int)207, (int)responseFind.getStatus());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PropFindResponseEntity entity = (PropFindResponseEntity)responseFind.getEntity();
        entity.write((OutputStream)outputStream);
        String find = outputStream.toString();
        TestPropFind.assertTrue((boolean)find.contains(WEBDAV_AUTHOR_PROPERTY));
        TestPropFind.assertTrue((boolean)find.contains(AUTHOR));
    }

    public void testNonEmptyMultiPropFind() throws Exception {
        String content = TestUtils.getFileContent();
        String file = TestUtils.getFileName();
        String[] propValues = new String[]{"No sacrifice is too great in the service of freedom.", "Freedom is the right of all sentient beings."};
        Node node = TestUtils.addContent((Session)this.session, file, new ByteArrayInputStream(content.getBytes()), WEBDAV_NT_FILE, WEBDAV_NT_RESOURCE, CONTENT_TYPE);
        node.getNode("jcr:content").setProperty(WEBDAV_TEST_PROPERTY, propValues);
        this.session.save();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Content-Type", (Object)CONTENT_TYPE);
        ContainerResponse responseFind = this.service("PROPFIND", this.getPathWS() + file, "", (MultivaluedMap<String, String>)headers, this.multiPropFindXML.getBytes());
        TestPropFind.assertEquals((int)207, (int)responseFind.getStatus());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PropFindResponseEntity entity = (PropFindResponseEntity)responseFind.getEntity();
        entity.write((OutputStream)outputStream);
        String find = outputStream.toString();
        TestPropFind.assertTrue((String)"Response should contain requested property element.", (boolean)find.contains(WEBDAV_TEST_PROPERTY));
        TestPropFind.assertTrue((String)"Property element should contain value data.", (boolean)find.contains("No sacrifice is too great in the service of freedom."));
    }

    public void testEmptyMultiPropFind() throws Exception {
        String content = TestUtils.getFileContent();
        String file = TestUtils.getFileName();
        Node node = TestUtils.addContent((Session)this.session, file, new ByteArrayInputStream(content.getBytes()), WEBDAV_NT_FILE, WEBDAV_NT_RESOURCE, CONTENT_TYPE);
        node.getNode("jcr:content").setProperty(WEBDAV_TEST_PROPERTY, new String[0]);
        this.session.save();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Content-Type", (Object)CONTENT_TYPE);
        ContainerResponse responseFind = this.service("PROPFIND", this.getPathWS() + file, "", (MultivaluedMap<String, String>)headers, this.multiPropFindXML.getBytes());
        TestPropFind.assertEquals((int)207, (int)responseFind.getStatus());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PropFindResponseEntity entity = (PropFindResponseEntity)responseFind.getEntity();
        entity.write((OutputStream)outputStream);
        String find = outputStream.toString();
        TestPropFind.assertTrue((String)"Response should contain requested property element.", (boolean)find.contains(WEBDAV_TEST_PROPERTY));
    }

    public void testPropNames() throws Exception {
        String content = TestUtils.getFileContent();
        String file = TestUtils.getFileName();
        TestUtils.addContent((Session)this.session, file, new ByteArrayInputStream(content.getBytes()), WEBDAV_NT_FILE, "");
        TestUtils.addNodeProperty((Session)this.session, file, WEBDAV_AUTHOR_PROPERTY, AUTHOR);
        ContainerResponse responseFind = this.service("PROPFIND", this.getPathWS() + file, "", null, this.propnameXML.getBytes());
        TestPropFind.assertEquals((int)207, (int)responseFind.getStatus());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PropFindResponseEntity entity = (PropFindResponseEntity)responseFind.getEntity();
        entity.write((OutputStream)outputStream);
        String find = outputStream.toString();
        TestPropFind.assertTrue((boolean)find.contains(WEBDAV_AUTHOR_PROPERTY));
        TestPropFind.assertTrue((boolean)find.contains("D:getlastmodified"));
        TestPropFind.assertFalse((boolean)find.contains("jcr:lockOwner"));
        TestPropFind.assertFalse((boolean)find.contains("D:lockdiscovery"));
    }

    public void testAllProps() throws Exception {
        String content = TestUtils.getFileContent();
        String file = TestUtils.getFileName();
        TestUtils.addContent((Session)this.session, file, new ByteArrayInputStream(content.getBytes()), WEBDAV_NT_FILE, "");
        TestUtils.addNodeProperty((Session)this.session, file, WEBDAV_AUTHOR_PROPERTY, AUTHOR);
        ContainerResponse responseFind = this.service("PROPFIND", this.getPathWS() + file, "", null, this.allPropsXML.getBytes());
        TestPropFind.assertEquals((int)207, (int)responseFind.getStatus());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PropFindResponseEntity entity = (PropFindResponseEntity)responseFind.getEntity();
        entity.write((OutputStream)outputStream);
        String find = outputStream.toString();
        TestPropFind.assertTrue((boolean)find.contains("D:getlastmodified"));
        TestPropFind.assertTrue((boolean)find.contains(WEBDAV_AUTHOR_PROPERTY));
        TestPropFind.assertTrue((boolean)find.contains(AUTHOR));
    }

    public void testAllPropsWithInclusion() throws Exception {
        String content = TestUtils.getFileContent();
        String file = TestUtils.getFileName();
        Node node = TestUtils.addContent((Session)this.session, file, new ByteArrayInputStream(content.getBytes()), WEBDAV_NT_FILE, "");
        node.addMixin("mix:lockable");
        node.save();
        node.lock(true, false);
        node.getPath();
        node.getName();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.add((Object)"Content-Type", (Object)CONTENT_TYPE);
        ContainerResponse responseFind = this.service("PROPFIND", this.getPathWS() + file, "", null, this.allPropsWithInclusionXML.getBytes());
        TestPropFind.assertEquals((int)207, (int)responseFind.getStatus());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PropFindResponseEntity entity = (PropFindResponseEntity)responseFind.getEntity();
        entity.write((OutputStream)outputStream);
        String find = outputStream.toString();
        TestPropFind.assertTrue((boolean)find.contains("D:lockdiscovery"));
        TestPropFind.assertTrue((boolean)find.contains("D:supported-method-set"));
    }

    public void testPropfindWrongDataFormat() throws Exception {
        String path = this.testPropFind.getPath() + "/testPropfindComplexContent";
        Node node = TestUtils.addContent((Session)this.session, path, new ByteArrayInputStream("file content".getBytes()), "nt:file", WEBDAV_NT_RESOURCE, "text/plain");
        node.addMixin("mix:lockable");
        node.save();
        node.lock(false, false);
        node.getNode("jcr:content").addMixin("mix:lockable");
        node.save();
        node.getNode("jcr:content").lock(true, false);
        node.getNode("jcr:content").addNode("node", "nt:unstructured").setProperty("node-prop", "prop");
        node.getNode("jcr:content").setProperty("exo:prop", "prop");
        node.save();
        HierarchicalProperty body = new HierarchicalProperty("D:propfind", null, "DAV:");
        body.addChild(new HierarchicalProperty("D:allprop", null, "DAV:"));
        Response resp = new PropFindCommand().propfind((Session)this.session, path, body, -1, BASE_URI);
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        ((PropFindResponseEntity)resp.getEntity()).write((OutputStream)bas);
        String find = new String(bas.toByteArray());
        TestPropFind.assertFalse((boolean)find.contains("jcr:lockOnwer"));
        TestPropFind.assertFalse((boolean)find.contains("D:lockdiscovery"));
    }

    public void testPropWithPercent() throws Exception {
        String content = TestUtils.getFileContent();
        String file = TestUtils.getFileName();
        TestUtils.addContent((Session)this.session, file, new ByteArrayInputStream(content.getBytes()), WEBDAV_NT_FILE, "");
        String authorValue = "bla % bla";
        TestUtils.addNodeProperty((Session)this.session, file, WEBDAV_AUTHOR_PROPERTY, authorValue);
        ContainerResponse responseFind = this.service("PROPFIND", this.getPathWS() + file, "", null, this.allPropsXML.getBytes());
        TestPropFind.assertEquals((int)207, (int)responseFind.getStatus());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PropFindResponseEntity entity = (PropFindResponseEntity)responseFind.getEntity();
        entity.write((OutputStream)outputStream);
        String find = outputStream.toString();
        TestPropFind.assertTrue((boolean)find.contains("D:getlastmodified"));
        TestPropFind.assertTrue((boolean)find.contains(WEBDAV_AUTHOR_PROPERTY));
        TestPropFind.assertTrue((boolean)find.contains(authorValue));
    }

    public void testPropfindPermissionsOnRoot() throws Exception {
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"Depth", (Object)"0");
        EnvironmentContext ctx = new EnvironmentContext();
        HashSet<String> adminRoles = new HashSet<String>();
        adminRoles.add("administrators");
        DummySecurityContext adminSecurityContext = new DummySecurityContext(new Principal(this){

            @Override
            public String getName() {
                return TestPropFind.USER_ROOT;
            }
        }, adminRoles);
        ctx.put(SecurityContext.class, (Object)adminSecurityContext);
        RequestHandlerImpl handler = (RequestHandlerImpl)this.container.getComponentInstanceOfType(RequestHandlerImpl.class);
        ResourceLauncher launcher = new ResourceLauncher((RequestHandler)handler);
        String request = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:propfind xmlns:D=\"DAV:\"><D:prop><D:owner/><D:acl/></D:prop></D:propfind>";
        ContainerResponse response = launcher.service("PROPFIND", this.getPathWS(), BASE_URI, (Map)headers, request.getBytes(), null, ctx);
        TestPropFind.assertEquals((int)207, (int)response.getStatus());
        TestPropFind.assertNotNull((Object)response.getEntity());
        HierarchicalPropertyEntityProvider provider = new HierarchicalPropertyEntityProvider();
        InputStream inputStream = TestUtils.getResponseAsStream(response);
        HierarchicalProperty multistatus = provider.readFrom(null, null, null, null, null, inputStream);
        TestPropFind.assertEquals((Object)new QName("DAV:", "multistatus"), (Object)multistatus.getName());
        TestPropFind.assertEquals((int)1, (int)multistatus.getChildren().size());
        HierarchicalProperty resourceProp = (HierarchicalProperty)multistatus.getChildren().get(0);
        HierarchicalProperty resourceHref = resourceProp.getChild(new QName("DAV:", "href"));
        TestPropFind.assertNotNull((Object)resourceHref);
        TestPropFind.assertEquals((String)(BASE_URI + this.getPathWS() + "/"), (String)resourceHref.getValue());
        HierarchicalProperty propstatProp = resourceProp.getChild(new QName("DAV:", "propstat"));
        HierarchicalProperty propProp = propstatProp.getChild(new QName("DAV:", "prop"));
        HierarchicalProperty ownerProp = propProp.getChild(new QName("DAV:", "owner"));
        HierarchicalProperty ownerHrefProp = ownerProp.getChild(new QName("DAV:", "href"));
        TestPropFind.assertEquals((String)"__system", (String)ownerHrefProp.getValue());
        HierarchicalProperty aclProp = propProp.getChild(ACLProperties.ACL);
        TestPropFind.assertEquals((int)1, (int)aclProp.getChildren().size());
        HierarchicalProperty aceProp = aclProp.getChild(ACLProperties.ACE);
        TestPropFind.assertEquals((int)2, (int)aceProp.getChildren().size());
        HierarchicalProperty principalProp = aceProp.getChild(ACLProperties.PRINCIPAL);
        TestPropFind.assertEquals((int)1, (int)principalProp.getChildren().size());
        HierarchicalProperty allProp = principalProp.getChild(ACLProperties.ALL);
        TestPropFind.assertNotNull((Object)allProp);
        HierarchicalProperty grantProp = aceProp.getChild(ACLProperties.GRANT);
        TestPropFind.assertEquals((int)2, (int)grantProp.getChildren().size());
        HierarchicalProperty writeProp = grantProp.getChild(0).getChild(ACLProperties.WRITE);
        TestPropFind.assertNotNull((Object)writeProp);
        HierarchicalProperty readProp = grantProp.getChild(1).getChild(ACLProperties.READ);
        TestPropFind.assertNotNull((Object)readProp);
    }

    public void testPropfindPropOwnerAndAclOnNode() throws Exception {
        NodeImpl testNode = (NodeImpl)this.root.addNode("test_acl_property", "nt:folder");
        testNode.addMixin("exo:owneable");
        testNode.addMixin("exo:privilegeable");
        this.session.save();
        HashMap<String, String[]> permissions = new HashMap<String, String[]>();
        String userName = USER_JOHN;
        permissions.put(userName, PermissionType.ALL);
        testNode.setPermissions(permissions);
        testNode.getSession().save();
        MultivaluedMapImpl headers = new MultivaluedMapImpl();
        headers.putSingle((Object)"Depth", (Object)"1");
        headers.putSingle((Object)"Content-Type", (Object)"text/xml; charset=\"utf-8\"");
        EnvironmentContext ctx = new EnvironmentContext();
        HashSet<String> adminRoles = new HashSet<String>();
        adminRoles.add("administrators");
        DummySecurityContext adminSecurityContext = new DummySecurityContext(new Principal(this){

            @Override
            public String getName() {
                return TestPropFind.USER_ROOT;
            }
        }, adminRoles);
        ctx.put(SecurityContext.class, (Object)adminSecurityContext);
        RequestHandlerImpl handler = (RequestHandlerImpl)this.container.getComponentInstanceOfType(RequestHandlerImpl.class);
        ResourceLauncher launcher = new ResourceLauncher((RequestHandler)handler);
        String request = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:propfind xmlns:D=\"DAV:\"><D:prop><D:owner/><D:acl/></D:prop></D:propfind>";
        ContainerResponse cres = launcher.service("PROPFIND", this.getPathWS() + testNode.getPath(), BASE_URI, (Map)headers, request.getBytes(), null, ctx);
        TestPropFind.assertEquals((int)207, (int)cres.getStatus());
        HierarchicalPropertyEntityProvider provider = new HierarchicalPropertyEntityProvider();
        InputStream inputStream = TestUtils.getResponseAsStream(cres);
        HierarchicalProperty multistatus = provider.readFrom(null, null, null, null, null, inputStream);
        TestPropFind.assertEquals((Object)new QName("DAV:", "multistatus"), (Object)multistatus.getName());
        TestPropFind.assertEquals((int)1, (int)multistatus.getChildren().size());
        HierarchicalProperty resourceProp = (HierarchicalProperty)multistatus.getChildren().get(0);
        HierarchicalProperty resourceHref = resourceProp.getChild(new QName("DAV:", "href"));
        TestPropFind.assertNotNull((Object)resourceHref);
        TestPropFind.assertEquals((String)(BASE_URI + this.getPathWS() + testNode.getPath() + "/"), (String)resourceHref.getValue());
        HierarchicalProperty propstatProp = resourceProp.getChild(new QName("DAV:", "propstat"));
        HierarchicalProperty propProp = propstatProp.getChild(new QName("DAV:", "prop"));
        HierarchicalProperty aclProp = propProp.getChild(ACLProperties.ACL);
        TestPropFind.assertEquals((int)1, (int)aclProp.getChildren().size());
        HierarchicalProperty aceProp = aclProp.getChild(ACLProperties.ACE);
        TestPropFind.assertEquals((int)2, (int)aceProp.getChildren().size());
        HierarchicalProperty principalProp = aceProp.getChild(ACLProperties.PRINCIPAL);
        TestPropFind.assertEquals((int)1, (int)principalProp.getChildren().size());
        TestPropFind.assertEquals((String)userName, (String)((HierarchicalProperty)principalProp.getChildren().get(0)).getValue());
        HierarchicalProperty grantProp = aceProp.getChild(ACLProperties.GRANT);
        TestPropFind.assertEquals((int)2, (int)grantProp.getChildren().size());
        HierarchicalProperty writeProp = grantProp.getChild(0).getChild(ACLProperties.WRITE);
        TestPropFind.assertNotNull((Object)writeProp);
        HierarchicalProperty readProp = grantProp.getChild(1).getChild(ACLProperties.READ);
        TestPropFind.assertNotNull((Object)readProp);
    }

    public void testPropFindForNonExistingWorkspace() throws Exception {
        String file = TestUtils.getFileName();
        ContainerResponse response = this.service("PROPFIND", this.getPathWS() + "_" + file, "", null, null);
        TestPropFind.assertEquals((int)409, (int)response.getStatus());
    }

    public void testFolderListingAllowed() throws Exception {
        TestUtils.addFolder((Session)this.session2, "/folder1", this.defaultFolderNodeType, "");
        ContainerResponse response = this.service("PROPFIND", this.getPathWS() + "2", "", null, null);
        TestPropFind.assertEquals((int)404, (int)response.getStatus());
        response = this.service("PROPFIND", this.getPathWS() + "2/folder1/folder2", "", null, null);
        TestPropFind.assertEquals((int)404, (int)response.getStatus());
        TestUtils.addFolder((Session)this.session2, "/folder1/folder4", this.defaultFolderNodeType, "");
        TestUtils.addFolder((Session)this.session2, "/folder1/folder4/folder5", this.defaultFolderNodeType, "");
        response = this.service("PROPFIND", this.getPathWS() + "2/folder1/folder4/folder5", "", null, null);
        TestPropFind.assertEquals((int)207, (int)response.getStatus());
    }

    public void testAllPropsWithEmptyMultiValuedProperty() throws Exception {
        String content = TestUtils.getFileContent();
        String file = TestUtils.getFileName();
        TestUtils.addContent((Session)this.session, file, new ByteArrayInputStream(content.getBytes()), WEBDAV_NT_FILE, "");
        Node fileNode = this.session.getRootNode().getNode(TextUtil.relativizePath((String)file));
        fileNode.addMixin("dc:elementSet");
        fileNode.setProperty("dc:title", new String[0]);
        Node contentNode = fileNode.getNode("jcr:content");
        contentNode.addMixin("dc:elementSet");
        contentNode.setProperty("dc:creator", new String[0]);
        this.session.save();
        ContainerResponse responseFind = this.service("PROPFIND", this.getPathWS() + file, "", null, this.allPropsXML.getBytes());
        TestPropFind.assertEquals((int)207, (int)responseFind.getStatus());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PropFindResponseEntity entity = (PropFindResponseEntity)responseFind.getEntity();
        entity.write((OutputStream)outputStream);
        String find = outputStream.toString();
        TestPropFind.assertTrue((boolean)find.contains("<dc:title xmlns:dc=\"http://purl.org/dc/elements/1.1/\"></dc:title>"));
        TestPropFind.assertTrue((boolean)find.contains("<dc:creator xmlns:dc=\"http://purl.org/dc/elements/1.1/\"></dc:creator>"));
    }

    public void testPropFindWithEmptyMultiValuedProperty() throws Exception {
        Node node = this.session.getRootNode().addNode("propertyDefNode", "nt:unstructured");
        node.setProperty("jcr:defaultValue", new String[0]);
        this.session.save();
        ContainerResponse responseFind = this.service("PROPFIND", this.getPathWS() + node.getPath(), "", null, this.allPropsXML.getBytes());
        TestPropFind.assertEquals((int)207, (int)responseFind.getStatus());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PropFindResponseEntity entity = (PropFindResponseEntity)responseFind.getEntity();
        entity.write((OutputStream)outputStream);
        String find = outputStream.toString();
        TestPropFind.assertTrue((boolean)find.contains("<jcr:defaultValue xmlns:jcr=\"http://www.jcp.org/jcr/1.0\"></jcr:defaultValue>"));
    }

    @Override
    protected String getRepositoryName() {
        return null;
    }
}

